/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuildRequest;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.AbstractToolboxCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.uberfire.mvp.Command;

public abstract class AbstractBuilderCommand<I>
extends AbstractToolboxCommand<I> {
    private static Logger LOGGER = Logger.getLogger(AbstractBuilderCommand.class.getName());
    private final ClientFactoryService clientFactoryServices;
    private final GraphBoundsIndexer graphBoundsIndexer;
    private CanvasHighlight canvasHighlight;

    public AbstractBuilderCommand(ClientFactoryService clientFactoryServices, GraphBoundsIndexer graphBoundsIndexer) {
        this.clientFactoryServices = clientFactoryServices;
        this.graphBoundsIndexer = graphBoundsIndexer;
    }

    protected abstract String getDefinitionIdentifier(Context<AbstractCanvasHandler> var1);

    protected abstract DragProxy getDragProxyFactory();

    protected abstract DragProxyCallback getDragProxyCallback(Context<AbstractCanvasHandler> var1, Element var2, Element var3);

    protected abstract BuilderControl getBuilderControl();

    protected abstract Object createtBuilderControlItem(Context<AbstractCanvasHandler> var1, Element var2, Element var3);

    protected abstract boolean onDragProxyMove(int var1, int var2, Element var3, Element var4, Node var5);

    protected abstract BuildRequest createBuildRequest(int var1, int var2, Element var3, Element var4, Node var5);

    protected void onDefinitionInstanceBuilt(Context<AbstractCanvasHandler> context, Element source, Element newElement, Command callback) {
        callback.execute();
    }

    @Override
    public void mouseDown(Context<AbstractCanvasHandler> context, Element element) {
        super.mouseDown(context, element);
        this.showDragProxy(context, element);
    }

    @Override
    public void click(Context<AbstractCanvasHandler> context, Element element) {
        super.click(context, element);
    }

    private void showDragProxy(final Context<AbstractCanvasHandler> context, final Element element) {
        final AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)context.getCanvasHandler();
        final double x = context.getAbsoluteX();
        final double y = context.getAbsoluteY();
        this.graphBoundsIndexer.setRootUUID(canvasHandler.getDiagram().getMetadata().getCanvasRootUUID());
        this.clientFactoryServices.newElement(UUID.uuid(), this.getDefinitionIdentifier(context), new ServiceCallback<Element>(){

            public void onSuccess(Element item) {
                AbstractBuilderCommand.this.onDefinitionInstanceBuilt((Context<AbstractCanvasHandler>)context, element, item, () -> {
                    AbstractBuilderCommand.this.getBuilderControl().enable((Object)canvasHandler);
                    AbstractBuilderCommand.this.canvasHighlight = new CanvasHighlight(canvasHandler);
                    AbstractBuilderCommand.this.graphBoundsIndexer.build((Object)canvasHandler.getDiagram().getGraph());
                    DragProxyCallback proxyCallback = AbstractBuilderCommand.this.getDragProxyCallback((Context<AbstractCanvasHandler>)context, element, item);
                    AbstractBuilderCommand.this.getDragProxyFactory().proxyFor((Object)canvasHandler).show(AbstractBuilderCommand.this.createtBuilderControlItem((Context<AbstractCanvasHandler>)context, element, item), (int)x, (int)y, (Object)proxyCallback);
                });
            }

            public void onError(ClientRuntimeError error) {
                AbstractBuilderCommand.this.onError((Context<AbstractCanvasHandler>)context, error);
            }
        });
    }

    protected void onStart(Context<AbstractCanvasHandler> context, Element element, Element item, int x1, int y1) {
    }

    protected void onMove(Context<AbstractCanvasHandler> context, Element element, Element item, int x1, int y1) {
        Node targetNode = (Node)this.graphBoundsIndexer.getAt((double)x1, (double)y1);
        boolean accepts = this.onDragProxyMove(x1, y1, element, item, targetNode);
        if (null != targetNode && accepts) {
            this.canvasHighlight.highLight(targetNode);
        } else if (null != targetNode) {
            this.canvasHighlight.invalid(targetNode);
        }
    }

    protected void onComplete(final Context<AbstractCanvasHandler> context, Element element, Element item, int x1, int y1) {
        this.fireLoadingStarted(context);
        Node targetNode = (Node)this.graphBoundsIndexer.getAt((double)x1, (double)y1);
        this.log(Level.INFO, "Completing element creation - Creating node for parent [" + (null != targetNode ? targetNode.getUUID() : "null"));
        if (null != targetNode) {
            this.ensureUnHighLight();
            BuildRequest buildRequest = this.createBuildRequest(x1, y1, element, item, targetNode);
            this.getBuilderControl().build(buildRequest, new BuilderControl.BuildCallback(){

                public void onSuccess(String uuid) {
                    AbstractBuilderCommand.this.log(Level.INFO, "Item build with UUID [" + uuid + "]");
                    AbstractBuilderCommand.this.onItemBuilt((Context<AbstractCanvasHandler>)context, uuid);
                    AbstractBuilderCommand.this.fireLoadingCompleted((Context<AbstractCanvasHandler>)context);
                }

                public void onError(ClientRuntimeError error) {
                    AbstractBuilderCommand.this.onError((Context<AbstractCanvasHandler>)context, error);
                }
            });
        }
        ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().getView().setCursor(AbstractCanvas.Cursors.AUTO);
    }

    protected void onError(Context<AbstractCanvasHandler> context, ClientRuntimeError error) {
        this.fireLoadingCompleted(context);
        LOGGER.log(Level.SEVERE, error.toString());
    }

    protected void onItemBuilt(Context<AbstractCanvasHandler> context, String uuid) {
    }

    public void destroy() {
        this.getDragProxyFactory().destroy();
        this.getBuilderControl().disable();
        this.graphBoundsIndexer.destroy();
        if (null != this.canvasHighlight) {
            this.canvasHighlight.destroy();
            this.canvasHighlight = null;
        }
    }

    protected ClientFactoryService getClientFactoryServices() {
        return this.clientFactoryServices;
    }

    protected GraphBoundsIndexer getGraphBoundsIndexer() {
        return this.graphBoundsIndexer;
    }

    private void ensureUnHighLight() {
        if (null != this.canvasHighlight) {
            this.canvasHighlight.unhighLight();
        }
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

