/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuildRequest;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.EdgeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.EdgeBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder.AbstractElementBuilderCommand;
import org.kie.workbench.common.stunner.core.client.components.drag.ConnectorDragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.uberfire.mvp.Command;

@Dependent
public class NewConnectorCommand<I>
extends AbstractElementBuilderCommand<I> {
    private final ConnectorDragProxy<AbstractCanvasHandler> connectorDragProxyFactory;
    private final EdgeBuilderControl<AbstractCanvasHandler> edgeBuilderControl;
    private String edgeId;

    protected NewConnectorCommand() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public NewConnectorCommand(ClientFactoryService clientFactoryServices, ShapeManager shapeManager, DefinitionGlyphTooltip<?> glyphTooltip, GraphBoundsIndexer graphBoundsIndexer, ConnectorDragProxy<AbstractCanvasHandler> connectorDragProxyFactory, EdgeBuilderControl<AbstractCanvasHandler> edgeBuilderControl) {
        super(clientFactoryServices, shapeManager, glyphTooltip, graphBoundsIndexer);
        this.connectorDragProxyFactory = connectorDragProxyFactory;
        this.edgeBuilderControl = edgeBuilderControl;
    }

    @PostConstruct
    public void init() {
        this.getGlyphTooltip().setPrefix("Click and move to connect using a ");
    }

    public void setEdgeIdentifier(String edgeId) {
        this.edgeId = edgeId;
    }

    @Override
    protected String getDefinitionIdentifier(Context<AbstractCanvasHandler> context) {
        return this.edgeId;
    }

    @Override
    protected String getGlyphDefinitionId() {
        return this.edgeId;
    }

    public String getTitle() {
        return "Creates a new connector";
    }

    @Override
    public void click(Context<AbstractCanvasHandler> context, Element element) {
        super.click(context, element);
        this.mouseDown(context, element);
    }

    @Override
    protected DragProxy getDragProxyFactory() {
        return this.connectorDragProxyFactory;
    }

    @Override
    protected BuilderControl getBuilderControl() {
        return this.edgeBuilderControl;
    }

    @Override
    protected Object createtBuilderControlItem(Context<AbstractCanvasHandler> context, Element source, Element newElement) {
        final Node sourceNode = (Node)source;
        final Edge edge = (Edge)newElement;
        final ShapeFactory edgeFactory = this.getFactory((AbstractCanvasHandler)context.getCanvasHandler());
        return new ConnectorDragProxy.Item(){

            public Edge<View<?>, Node> getEdge() {
                return edge;
            }

            public Node<View<?>, Edge> getSourceNode() {
                return sourceNode;
            }

            public ShapeFactory getShapeFactory() {
                return edgeFactory;
            }
        };
    }

    @Override
    protected void onDefinitionInstanceBuilt(Context<AbstractCanvasHandler> context, Element source, Element newElement, Command callback) {
        Node sourceNode = (Node)source;
        Edge edge = (Edge)newElement;
        edge.setSourceNode(sourceNode);
        NewConnectorCommand.access$001(this, context, source, newElement, callback);
    }

    @Override
    protected boolean onDragProxyMove(int x, int y, Element source, Element newElement, Node targetNode) {
        Node sourceNode = (Node)source;
        Edge edge = (Edge)newElement;
        if (null != targetNode) {
            EdgeBuildRequestImpl request = new EdgeBuildRequestImpl(x, y, edge, sourceNode, targetNode);
            return this.edgeBuilderControl.allows((BuildRequest)request);
        }
        return false;
    }

    @Override
    protected BuildRequest createBuildRequest(int x, int y, Element source, Element newElement, Node targetNode) {
        Node sourceNode = (Node)source;
        Edge edge = (Edge)newElement;
        return new EdgeBuildRequestImpl(x, y, edge, sourceNode, targetNode);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    static /* synthetic */ void access$001(NewConnectorCommand x0, Context x1, Element x2, Element x3, Command x4) {
        super.onDefinitionInstanceBuilt((Context<AbstractCanvasHandler>)x1, x2, x3, x4);
    }
}

