/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuildRequest;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.NodeBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder.AbstractElementBuilderCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.definition.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.uberfire.mvp.Command;

@Dependent
public class NewNodeCommand<I>
extends AbstractElementBuilderCommand<I> {
    private static Logger LOGGER = Logger.getLogger(NewNodeCommand.class.getName());
    private final NodeDragProxy<AbstractCanvasHandler> nodeDragProxyFactory;
    private final NodeBuilderControl<AbstractCanvasHandler> nodeBuilderControl;
    private final Event<CanvasElementSelectedEvent> elementSelectedEvent;
    private final DefinitionUtils definitionUtils;
    private final CanvasLayoutUtils canvasLayoutUtils;
    private String definitionId;
    private int sourceMagnet;
    private int targetMagnet;
    private HasEventHandlers<?, ?> layerEventHandlers;

    protected NewNodeCommand() {
        this(null, null, null, null, null, null, null, null, null);
    }

    @Inject
    public NewNodeCommand(ClientFactoryService clientFactoryServices, ShapeManager shapeManager, DefinitionGlyphTooltip<?> glyphTooltip, GraphBoundsIndexer graphBoundsIndexer, NodeDragProxy<AbstractCanvasHandler> nodeDragProxyFactory, NodeBuilderControl<AbstractCanvasHandler> nodeBuilderControl, DefinitionUtils definitionUtils, CanvasLayoutUtils canvasLayoutUtils, Event<CanvasElementSelectedEvent> elementSelectedEvent) {
        super(clientFactoryServices, shapeManager, glyphTooltip, graphBoundsIndexer);
        this.nodeDragProxyFactory = nodeDragProxyFactory;
        this.nodeBuilderControl = nodeBuilderControl;
        this.definitionUtils = definitionUtils;
        this.canvasLayoutUtils = canvasLayoutUtils;
        this.elementSelectedEvent = elementSelectedEvent;
        this.layerEventHandlers = null;
    }

    @PostConstruct
    public void init() {
        this.getGlyphTooltip().setPrefix("Click to create a ");
    }

    public void setDefinitionIdentifier(String definitionId) {
        this.definitionId = definitionId;
    }

    private String getEdgeIdentifier(Context<AbstractCanvasHandler> context) {
        String defSetId = ((AbstractCanvasHandler)context.getCanvasHandler()).getDiagram().getMetadata().getDefinitionSetId();
        return this.definitionUtils.getDefaultConnectorId(defSetId);
    }

    @Override
    protected String getDefinitionIdentifier(Context<AbstractCanvasHandler> context) {
        return this.getEdgeIdentifier(context);
    }

    @Override
    protected String getGlyphDefinitionId() {
        return this.definitionId;
    }

    public String getTitle() {
        return "Creates a new node";
    }

    @Override
    public void click(Context<AbstractCanvasHandler> context, Element element) {
        super.click(context, element);
        this.log(Level.INFO, "Click - Start adding a new node...");
        this.addOnNextLayoutPosition(context, element);
    }

    private void addOnNextLayoutPosition(final Context<AbstractCanvasHandler> context, final Element element) {
        this.fireLoadingStarted(context);
        final AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)context.getCanvasHandler();
        this.getGraphBoundsIndexer().setRootUUID(canvasHandler.getDiagram().getMetadata().getCanvasRootUUID());
        this.getGraphBoundsIndexer().build((Object)canvasHandler.getDiagram().getGraph());
        this.getClientFactoryServices().newElement(UUID.uuid(), this.getDefinitionIdentifier(context), new ServiceCallback<Element>(){

            public void onSuccess(final Element newEdgeElement) {
                NewNodeCommand.this.onDefinitionInstanceBuilt((Context<AbstractCanvasHandler>)context, element, newEdgeElement, new Command(){

                    public void execute() {
                        NewNodeCommand.this.getBuilderControl().enable((Object)canvasHandler);
                        NewNodeCommand.this.getGraphBoundsIndexer().build((Object)canvasHandler.getDiagram().getGraph());
                        NewNodeCommand.this.sourceMagnet = 3;
                        NewNodeCommand.this.targetMagnet = 7;
                        double[] next = NewNodeCommand.this.canvasLayoutUtils.getNext(canvasHandler, (Node)element);
                        NewNodeCommand.this.log(Level.INFO, "New edge request complete - [UUID=" + newEdgeElement.getUUID() + ", x=" + next[0] + ", y=" + next[1] + "]");
                        NewNodeCommand.this.onComplete((Context<AbstractCanvasHandler>)context, element, newEdgeElement, (int)next[0], (int)next[1]);
                    }
                });
            }

            public void onError(ClientRuntimeError error) {
                NewNodeCommand.this.onError((Context<AbstractCanvasHandler>)context, error);
            }
        });
    }

    @Override
    protected DragProxy getDragProxyFactory() {
        return this.nodeDragProxyFactory;
    }

    @Override
    protected BuilderControl getBuilderControl() {
        return this.nodeBuilderControl;
    }

    @Override
    protected DragProxyCallback getDragProxyCallback(final Context<AbstractCanvasHandler> context, final Element element, final Element item) {
        return new NodeDragProxyCallback(){

            public void onStart(int x, int y) {
                NewNodeCommand.this.onStart((Context<AbstractCanvasHandler>)context, element, item, x, y);
            }

            public void onMove(int x, int y) {
                NewNodeCommand.this.onMove((Context<AbstractCanvasHandler>)context, element, item, x, y);
            }

            public void onComplete(int x, int y) {
            }

            public void onComplete(int x, int y, int sourceMagnet, int targetMagnet) {
                NewNodeCommand.this.sourceMagnet = sourceMagnet;
                NewNodeCommand.this.targetMagnet = targetMagnet;
                NewNodeCommand.this.onComplete((Context<AbstractCanvasHandler>)context, element, item, x, y);
            }
        };
    }

    @Override
    protected void onStart(Context<AbstractCanvasHandler> context, Element element, Element item, int x1, int y1) {
        super.onStart(context, element, item, x1, y1);
        this.layerEventHandlers = this.getLayer(context);
        this.disableHandlers();
    }

    @Override
    protected void onItemBuilt(Context<AbstractCanvasHandler> context, String uuid) {
        super.onItemBuilt(context, uuid);
        this.fireElementSelectedEvent(this.elementSelectedEvent, (AbstractCanvasHandler)context.getCanvasHandler(), uuid);
    }

    @Override
    protected void onError(Context<AbstractCanvasHandler> context, ClientRuntimeError error) {
        super.onError(context, error);
        this.enableHandlers();
    }

    protected Layer getLayer(Context<AbstractCanvasHandler> context) {
        return ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().getLayer();
    }

    @Override
    protected void onDefinitionInstanceBuilt(final Context<AbstractCanvasHandler> context, final Element source, final Element newElement, final Command callback) {
        final Node sourceNode = (Node)source;
        final Edge edge = (Edge)newElement;
        this.getClientFactoryServices().newElement(UUID.uuid(), this.definitionId, new ServiceCallback<Element>(){

            public void onSuccess(Element item) {
                Node node = item.asNode();
                edge.setSourceNode(sourceNode);
                edge.setTargetNode(node);
                NewNodeCommand.access$401(NewNodeCommand.this, context, source, newElement, callback);
            }

            public void onError(ClientRuntimeError error) {
                NewNodeCommand.this.onError((Context<AbstractCanvasHandler>)context, error);
            }
        });
    }

    @Override
    protected Object createtBuilderControlItem(Context<AbstractCanvasHandler> context, Element source, Element newElement) {
        final Node sourceNode = (Node)source;
        final Edge edge = (Edge)newElement;
        final ShapeFactory shapeFactory = this.getFactory((AbstractCanvasHandler)context.getCanvasHandler());
        return new NodeDragProxy.Item<AbstractCanvasHandler>(){

            public Node<View<?>, Edge> getNode() {
                return edge.getTargetNode();
            }

            public ShapeFactory<?, AbstractCanvasHandler, ?> getNodeShapeFactory() {
                return shapeFactory;
            }

            public Edge<View<?>, Node> getInEdge() {
                return edge;
            }

            public Node<View<?>, Edge> getInEdgeSourceNode() {
                return sourceNode;
            }

            public ShapeFactory<?, AbstractCanvasHandler, ?> getInEdgeShapeFactory() {
                return shapeFactory;
            }
        };
    }

    @Override
    protected boolean onDragProxyMove(int x, int y, Element source, Element newElement, Node parent) {
        Edge edge = (Edge)newElement;
        Node node = edge.getTargetNode();
        NodeBuildRequestImpl request = new NodeBuildRequestImpl(x, y, node, edge);
        boolean accepts = this.nodeBuilderControl.allows((BuildRequest)request);
        return accepts && null != parent;
    }

    @Override
    protected BuildRequest createBuildRequest(int x, int y, Element source, Element newElement, Node targetNode) {
        Edge edge = (Edge)newElement;
        Node node = edge.getTargetNode();
        return new NodeBuildRequestImpl(x, y, node, edge, this.sourceMagnet, this.targetMagnet);
    }

    @Override
    protected void clearDragProxy() {
        super.clearDragProxy();
        this.enableHandlers();
    }

    private void disableHandlers() {
        if (null != this.layerEventHandlers) {
            this.layerEventHandlers.disableHandlers();
        }
    }

    private void enableHandlers() {
        if (null != this.layerEventHandlers) {
            this.layerEventHandlers.enableHandlers();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.layerEventHandlers = null;
    }

    protected String getDefinitionId(Object def) {
        return this.definitionUtils.getDefinitionManager().adapters().forDefinition().getId(def);
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    static /* synthetic */ void access$401(NewNodeCommand x0, Context x1, Element x2, Element x3, Command x4) {
        super.onDefinitionInstanceBuilt((Context<AbstractCanvasHandler>)x1, x2, x3, x4);
    }
}

