/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.graph.Node;

public class CanvasHighlight {
    private final AbstractCanvasHandler canvasHandler;
    private Shape shape;
    private long duration = 50L;

    public CanvasHighlight(AbstractCanvasHandler canvasHandler) {
        this.canvasHandler = canvasHandler;
    }

    public CanvasHighlight setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public void highLight(Node node) {
        this.applyState(node, ShapeState.HIGHLIGHT);
    }

    public void invalid(Node node) {
        this.applyState(node, ShapeState.INVALID);
    }

    public void none(Node node) {
        this.applyState(node, ShapeState.NONE);
    }

    private void applyState(Node node, ShapeState state) {
        String uuid;
        Shape shape;
        if (null != this.shape && !node.getUUID().equals(this.shape.getUUID())) {
            this.unhighLight();
        }
        if (null == this.shape && null != (shape = this.getShape(uuid = node.getUUID()))) {
            this.shape = shape;
            shape.applyState(state);
            this.getCanvas().draw();
        }
    }

    public void unhighLight() {
        if (null != this.shape) {
            this.shape.applyState(ShapeState.NONE);
            this.getCanvas().draw();
            this.shape = null;
        }
    }

    public void destroy() {
        this.shape = null;
    }

    private Shape getShape(String uuid) {
        return this.getCanvas().getShape(uuid);
    }

    private AbstractCanvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }
}

