/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandAllowedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandManagerFactory;
import org.kie.workbench.common.stunner.core.command.CommandManagerListener;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.HasCommandManagerListener;
import org.kie.workbench.common.stunner.core.command.delegate.DelegateCommandManager;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

class CanvasCommandManagerImpl
extends DelegateCommandManager<AbstractCanvasHandler, CanvasViolation>
implements CanvasCommandManager<AbstractCanvasHandler>,
HasCommandManagerListener<CommandManagerListener<AbstractCanvasHandler, CanvasViolation>> {
    private final Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent;
    private final Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent;
    private final Event<CanvasUndoCommandExecutedEvent> canvasUndoCommandExecutedEvent;
    private final CommandManager<AbstractCanvasHandler, CanvasViolation> commandManager;
    private CommandManagerListener<AbstractCanvasHandler, CanvasViolation> listener;

    CanvasCommandManagerImpl() {
        this(null, null, null, null);
    }

    CanvasCommandManagerImpl(Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent, Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent, Event<CanvasUndoCommandExecutedEvent> canvasUndoCommandExecutedEvent, CommandManagerFactory commandManagerFactory) {
        this.isCanvasCommandAllowedEvent = isCanvasCommandAllowedEvent;
        this.canvasCommandExecutedEvent = canvasCommandExecutedEvent;
        this.canvasUndoCommandExecutedEvent = canvasUndoCommandExecutedEvent;
        this.commandManager = commandManagerFactory.newCommandManager();
        this.listener = null;
    }

    protected CommandManager<AbstractCanvasHandler, CanvasViolation> getDelegate() {
        return this.commandManager;
    }

    protected void postAllow(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postAllow((Object)context, command, result);
        if (null != this.listener) {
            this.listener.onAllow((Object)context, command, result);
        }
        if (null != result && null != this.isCanvasCommandAllowedEvent) {
            this.isCanvasCommandAllowedEvent.fire((Object)new CanvasCommandAllowedEvent((CanvasHandler)context, command, result));
        }
    }

    protected void postExecute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postExecute((Object)context, command, result);
        if (null != result && !CommandUtils.isError(result)) {
            this.draw(context);
        }
        if (null != this.listener) {
            this.listener.onExecute((Object)context, command, result);
        }
        if (null != result && null != this.canvasCommandExecutedEvent) {
            this.canvasCommandExecutedEvent.fire((Object)new CanvasCommandExecutedEvent((CanvasHandler)context, command, result));
        }
    }

    protected void postUndo(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postUndo((Object)context, command, result);
        if (null != result && !CommandUtils.isError(result)) {
            this.draw(context);
        }
        if (null != this.listener) {
            this.listener.onUndo((Object)context, command, result);
        }
        if (null != this.canvasUndoCommandExecutedEvent) {
            this.canvasUndoCommandExecutedEvent.fire((Object)new CanvasUndoCommandExecutedEvent((CanvasHandler)context, command, result));
        }
    }

    public void setCommandManagerListener(CommandManagerListener<AbstractCanvasHandler, CanvasViolation> listener) {
        this.listener = listener;
    }

    private void draw(AbstractCanvasHandler context) {
        context.getCanvas().draw();
    }
}

