/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.Collection;
import java.util.LinkedList;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolationImpl;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandResultBuilder;
import org.kie.workbench.common.stunner.core.command.impl.CommandResultImpl;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class CanvasCommandResultBuilder
extends CommandResultBuilder<CanvasViolation> {
    public static final CommandResult<CanvasViolation> SUCCESS = new CommandResultImpl(CommandResult.Type.INFO, "Success", new LinkedList());
    public static final CommandResult<CanvasViolation> FAILED = new CommandResultImpl(CommandResult.Type.ERROR, "Failed", new LinkedList());

    public CanvasCommandResultBuilder() {
    }

    public CanvasCommandResultBuilder(Collection<CanvasViolation> violations) {
        super(violations);
    }

    public CanvasCommandResultBuilder(CommandResult<RuleViolation> commandResult) {
        this.setMessage(commandResult.getMessage());
        this.setType(commandResult.getType());
        Iterable violations = commandResult.getViolations();
        if (null != violations) {
            for (RuleViolation ruleViolation : violations) {
                CanvasViolation canvasViolation = new CanvasViolationImpl.CanvasViolationBuilder(ruleViolation).build();
                this.addViolation(canvasViolation);
            }
        }
    }

    public boolean isError(CanvasViolation violation) {
        return RuleViolation.Type.ERROR.equals((Object)violation.getViolationType());
    }

    public String getMessage(CanvasViolation violation) {
        return violation.getMessage();
    }
}

