/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.Session;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.delegate.DelegateCommandManager;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.command.stack.StackCommandManager;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;

@ApplicationScoped
@Session
public class SessionCommandManagerImpl
extends DelegateCommandManager<AbstractCanvasHandler, CanvasViolation>
implements SessionCommandManager<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(SessionCommandManagerImpl.class.getName());
    private final AbstractClientSessionManager clientSessionManager;

    protected SessionCommandManagerImpl() {
        this(null);
    }

    @Inject
    public SessionCommandManagerImpl(AbstractClientSessionManager clientSessionManager) {
        this.clientSessionManager = clientSessionManager;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
        try {
            return super.execute((Object)context, command);
        }
        catch (CommandException ce) {
            this.clientSessionManager.handleCommandError(ce);
        }
        catch (RuntimeException e) {
            this.clientSessionManager.handleClientError(new ClientRuntimeError((Throwable)e));
        }
        return CanvasCommandResultBuilder.FAILED;
    }

    protected CommandManager<AbstractCanvasHandler, CanvasViolation> getDelegate() {
        ClientFullSession<AbstractCanvas, AbstractCanvasHandler> defaultSession = this.getDefaultSession();
        if (null != defaultSession) {
            return defaultSession.getCanvasCommandManager();
        }
        return null;
    }

    private ClientFullSession<AbstractCanvas, AbstractCanvasHandler> getDefaultSession() {
        ClientSession<AbstractCanvas, AbstractCanvasHandler> session = this.getCurrentSession();
        if (session instanceof ClientFullSession) {
            return (ClientFullSession)session;
        }
        return null;
    }

    private ClientSession<AbstractCanvas, AbstractCanvasHandler> getCurrentSession() {
        return this.clientSessionManager.getCurrentSession();
    }

    public CommandRegistry<Command<AbstractCanvasHandler, CanvasViolation>> getRegistry() {
        StackCommandManager scm = (StackCommandManager)this.getDelegate();
        if (null != scm) {
            return scm.getRegistry();
        }
        return null;
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        StackCommandManager scm = (StackCommandManager)this.getDelegate();
        if (null != scm) {
            return scm.undo((Object)context);
        }
        return null;
    }

    public String toString() {
        return "[" + super.toString() + "] - Current session = [" + (null != this.getCurrentSession() ? this.getCurrentSession().toString() : "null") + "]";
    }
}

