/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.drag;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.drag.ShapeDragProxy;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.GraphShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.util.EdgeMagnetsHelper;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

@Dependent
public class NodeDragProxyImpl
implements NodeDragProxy<AbstractCanvasHandler> {
    private AbstractCanvasHandler canvasHandler;
    ShapeDragProxy<AbstractCanvas> shapeDragProxyFactory;
    EdgeMagnetsHelper magnetsHelper;
    private EdgeShape transientEdgeShape;

    @Inject
    public NodeDragProxyImpl(ShapeDragProxy<AbstractCanvas> shapeDragProxyFactory, EdgeMagnetsHelper magnetsHelper) {
        this.shapeDragProxyFactory = shapeDragProxyFactory;
        this.magnetsHelper = magnetsHelper;
    }

    public DragProxy<AbstractCanvasHandler, NodeDragProxy.Item, NodeDragProxyCallback> proxyFor(AbstractCanvasHandler context) {
        this.canvasHandler = context;
        this.shapeDragProxyFactory.proxyFor((Object)context.getCanvas());
        return this;
    }

    public DragProxy<AbstractCanvasHandler, NodeDragProxy.Item, NodeDragProxyCallback> show(NodeDragProxy.Item item, int x, int y, final NodeDragProxyCallback callback) {
        Canvas canvas = this.canvasHandler.getCanvas();
        Node node = item.getNode();
        ShapeFactory nodeShapeFactory = item.getNodeShapeFactory();
        Edge inEdge = item.getInEdge();
        Node inEdgeSourceNode = item.getInEdgeSourceNode();
        ShapeFactory edgeShapeFactory = item.getInEdgeShapeFactory();
        Shape nodeShape = nodeShapeFactory.build(((View)node.getContent()).getDefinition(), (Object)this.canvasHandler);
        if (nodeShape instanceof GraphShape) {
            ((GraphShape)nodeShape).applyProperties((Object)node, MutationContext.STATIC);
        }
        this.transientEdgeShape = (EdgeShape)edgeShapeFactory.build(((View)inEdge.getContent()).getDefinition(), (Object)this.canvasHandler);
        canvas.addTransientShape((Shape)this.transientEdgeShape);
        this.transientEdgeShape.applyProperties((Object)inEdge, MutationContext.STATIC);
        Shape edgeSourceNodeShape = this.canvasHandler.getCanvas().getShape(inEdgeSourceNode.getUUID());
        this.shapeDragProxyFactory.show((Object)nodeShape, x, y, (Object)new DragProxyCallback((AbstractCanvas)canvas, inEdge, edgeSourceNodeShape, nodeShape){
            final /* synthetic */ AbstractCanvas val$canvas;
            final /* synthetic */ Edge val$inEdge;
            final /* synthetic */ Shape val$edgeSourceNodeShape;
            final /* synthetic */ Shape val$nodeShape;
            {
                this.val$canvas = abstractCanvas;
                this.val$inEdge = edge;
                this.val$edgeSourceNodeShape = shape;
                this.val$nodeShape = shape2;
            }

            public void onStart(int x, int y) {
                callback.onStart(x, y);
                this.drawEdge();
            }

            public void onMove(int x, int y) {
                callback.onMove(x, y);
                this.drawEdge();
            }

            public void onComplete(int x, int y) {
                int[] magnets = this.getMagnets();
                callback.onComplete(x, y);
                callback.onComplete(x, y, magnets[0], magnets[1]);
                NodeDragProxyImpl.this.deleteTransientEdgeShape();
                this.val$canvas.draw();
            }

            private void drawEdge() {
                if (this.val$inEdge.getContent() instanceof ViewConnector) {
                    int[] magnets = this.getMagnets();
                    ViewConnector viewConnector = (ViewConnector)this.val$inEdge.getContent();
                    viewConnector.setSourceMagnetIndex(Integer.valueOf(magnets[0]));
                    viewConnector.setTargetMagnetIndex(Integer.valueOf(magnets[1]));
                }
                NodeDragProxyImpl.this.transientEdgeShape.applyConnections(this.val$inEdge, this.val$edgeSourceNodeShape.getShapeView(), this.val$nodeShape.getShapeView(), MutationContext.STATIC);
                this.val$canvas.draw();
            }

            private int[] getMagnets() {
                return NodeDragProxyImpl.this.magnetsHelper.getDefaultMagnetsIndex(this.val$edgeSourceNodeShape.getShapeView(), this.val$nodeShape.getShapeView());
            }
        });
        return this;
    }

    public void clear() {
        if (null != this.shapeDragProxyFactory) {
            this.shapeDragProxyFactory.clear();
        }
        this.deleteTransientEdgeShape();
    }

    public void destroy() {
        if (null != this.shapeDragProxyFactory) {
            this.clear();
            this.shapeDragProxyFactory.destroy();
        }
        this.shapeDragProxyFactory = null;
        this.canvasHandler = null;
        this.magnetsHelper = null;
        this.transientEdgeShape = null;
    }

    private AbstractCanvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    private void deleteTransientEdgeShape() {
        if (null != this.transientEdgeShape) {
            this.getCanvas().deleteTransientShape((Shape)this.transientEdgeShape);
            this.getCanvas().draw();
            this.transientEdgeShape = null;
        }
    }
}

