/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette;

import java.util.List;
import org.kie.workbench.common.stunner.core.client.components.palette.model.GlyphPaletteItem;

public class ClientPaletteUtils {
    public static String getLongestText(List<GlyphPaletteItem> paletteItems) {
        if (null == paletteItems || paletteItems.isEmpty()) {
            return null;
        }
        String longestTitle = "";
        for (GlyphPaletteItem item : paletteItems) {
            String iTitle = item.getTitle();
            if (null == iTitle || iTitle.length() <= longestTitle.length()) continue;
            longestTitle = iTitle;
        }
        return longestTitle.length() > 0 ? longestTitle : null;
    }

    public static double[] computeSizeForVerticalLayout(int itemsSize, int iconSize, int padding, int textLength) {
        return ClientPaletteUtils.computeSizeForLayout(itemsSize, iconSize, padding, textLength, true);
    }

    public static double[] computeSizeForHorizontalLayout(int itemsSize, int iconSize, int padding, int textLength) {
        return ClientPaletteUtils.computeSizeForLayout(itemsSize, iconSize, padding, textLength, false);
    }

    public static double computeFontSize(double width, double height, int textLength) {
        return 10.0;
    }

    public static double[] computeFontBoundingBoxSize(double fontSize, int textLength) {
        return new double[]{100.0, 50.0};
    }

    private static double[] computeSizeForLayout(int itemsSize, int iconSize, int padding, int textLength, boolean verticalLayout) {
        double width = 0.0;
        double height = 0.0;
        double fixedSize = iconSize + padding * 2;
        double dynSize = iconSize * itemsSize + padding * 2 * itemsSize;
        width = verticalLayout ? fixedSize : dynSize;
        double d = height = verticalLayout ? dynSize : fixedSize;
        if (textLength > 0) {
            double fontSize = ClientPaletteUtils.computeFontSize(fixedSize, fixedSize, textLength);
            double[] fontBBSize = ClientPaletteUtils.computeFontBoundingBoxSize(fontSize, textLength);
            width += verticalLayout ? fontBBSize[0] : 0.0;
            height += !verticalLayout ? fontBBSize[1] : 0.0;
        }
        return new double[]{width, height};
    }
}

