/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette.factory;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Instance;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.stunner.core.client.ShapeManager;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.DefSetPaletteDefinitionFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.DefaultDefSetPaletteDefinitionFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.PaletteDefinitionFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.PaletteFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.model.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;

public abstract class AbstractPaletteFactory<I extends HasPaletteItems, P extends Palette<I>>
implements PaletteFactory<I, P> {
    private static Logger LOGGER = Logger.getLogger(AbstractPaletteFactory.class.getName());
    protected SyncBeanManager beanManager;
    protected Instance<DefaultDefSetPaletteDefinitionFactory> defaultPaletteDefinitionFactoryInstance;
    protected ShapeManager shapeManager;
    protected final List<DefSetPaletteDefinitionFactory> paletteDefinitionFactories = new LinkedList<DefSetPaletteDefinitionFactory>();
    protected P palette;

    public AbstractPaletteFactory(ShapeManager shapeManager, SyncBeanManager beanManager, Instance<DefaultDefSetPaletteDefinitionFactory> defaultPaletteDefinitionFactoryInstance, P palette) {
        this.shapeManager = shapeManager;
        this.beanManager = beanManager;
        this.defaultPaletteDefinitionFactoryInstance = defaultPaletteDefinitionFactoryInstance;
        this.palette = palette;
    }

    protected abstract void applyGrid(PaletteGrid var1);

    public void init() {
        Collection factorySets = this.beanManager.lookupBeans(DefSetPaletteDefinitionFactory.class);
        for (SyncBeanDef defSet : factorySets) {
            DefSetPaletteDefinitionFactory factory = (DefSetPaletteDefinitionFactory)defSet.getInstance();
            this.paletteDefinitionFactories.add(factory);
        }
    }

    protected PaletteDefinitionFactory getPaletteDefinitionFactory(String defSetId) {
        for (DefSetPaletteDefinitionFactory factory : this.paletteDefinitionFactories) {
            if (!factory.accepts(defSetId)) continue;
            return factory;
        }
        return (PaletteDefinitionFactory)this.defaultPaletteDefinitionFactoryInstance.get();
    }

    public P newPalette(String shapeSetId) {
        return this.newPalette(shapeSetId, null);
    }

    public P newPalette(final String shapeSetId, final PaletteGrid grid) {
        String defSetId = this.getShapeSet(shapeSetId).getDefinitionSetId();
        PaletteDefinitionFactory paletteDefinitionFactory = this.getPaletteDefinitionFactory(defSetId);
        PaletteDefinitionBuilder paletteDefinitionBuilder = paletteDefinitionFactory.newBuilder(defSetId);
        paletteDefinitionBuilder.build((Object)defSetId, new PaletteDefinitionBuilder.Callback<I, ClientRuntimeError>(){

            public void onSuccess(I paletteDefinition) {
                AbstractPaletteFactory.this.applyGrid(grid);
                AbstractPaletteFactory.this.beforeBindPalette(paletteDefinition, shapeSetId);
                AbstractPaletteFactory.this.palette.bind(paletteDefinition);
                AbstractPaletteFactory.this.afterBindPalette(paletteDefinition, shapeSetId);
            }

            public void onError(ClientRuntimeError error) {
                AbstractPaletteFactory.this.logError(error);
            }
        });
        return this.palette;
    }

    protected void beforeBindPalette(I paletteDefinition, String shapeSetId) {
    }

    protected void afterBindPalette(I paletteDefinition, String shapeSetId) {
    }

    private ShapeSet getShapeSet(String id) {
        for (ShapeSet set : this.shapeManager.getShapeSets()) {
            if (!set.getId().equals(id)) continue;
            return set;
        }
        return null;
    }

    private void logError(ClientRuntimeError error) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(Level.SEVERE, error.toString());
        }
    }
}

