/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl;

import java.util.LinkedList;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.components.palette.model.AbstractPaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteCategory;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionSetPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionSetPaletteBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionPaletteCategoryImpl;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionPaletteGroupImpl;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionPaletteItemImpl;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionSetPaletteImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.definition.util.DefinitionUtils;

@Dependent
public class DefinitionSetPaletteBuilderImpl
extends AbstractPaletteDefinitionBuilder<Object, DefinitionSetPalette, ClientRuntimeError>
implements DefinitionSetPaletteBuilder {
    private final DefinitionUtils definitionUtils;
    private final ClientFactoryService clientFactoryServices;
    private DefinitionSetPaletteBuilder.PaletteCategoryProvider paletteCategoryProvider;
    private DefinitionSetPaletteBuilder.PaletteMorphGroupProvider paletteMorphGroupProvider;
    static final DefinitionSetPaletteBuilder.PaletteCategoryProvider CATEGORY_PROVIDER = new DefinitionSetPaletteBuilder.PaletteCategoryProvider(){

        @Override
        public String getTitle(String id) {
            return id;
        }

        @Override
        public String getDescription(String id) {
            return id;
        }

        @Override
        public String getDefinitionId(String id) {
            return null;
        }
    };
    static final DefinitionSetPaletteBuilder.PaletteMorphGroupProvider MORPH_GROUP_PROVIDER = new DefinitionSetPaletteBuilder.PaletteMorphGroupProvider(){

        @Override
        public String getTitle(String morphBaseId, Object definition) {
            return morphBaseId;
        }

        @Override
        public String getDescription(String morphBaseId, Object definition) {
            return morphBaseId;
        }
    };

    protected DefinitionSetPaletteBuilderImpl() {
        this(null, null);
    }

    @Inject
    public DefinitionSetPaletteBuilderImpl(DefinitionUtils definitionUtils, ClientFactoryService clientFactoryServices) {
        this.definitionUtils = definitionUtils;
        this.clientFactoryServices = clientFactoryServices;
        this.paletteCategoryProvider = CATEGORY_PROVIDER;
        this.paletteMorphGroupProvider = MORPH_GROUP_PROVIDER;
    }

    public void build(Object definitionSet, final PaletteDefinitionBuilder.Callback<DefinitionSetPalette, ClientRuntimeError> callback) {
        Object definitionSetObject = definitionSet instanceof String ? this.getDefinitionManager().definitionSets().getDefinitionSetById((String)definitionSet) : definitionSet;
        String defSetId = this.getDefinitionManager().adapters().forDefinitionSet().getId(definitionSetObject);
        Set definitions = this.getDefinitionManager().adapters().forDefinitionSet().getDefinitions(definitionSetObject);
        if (null != definitions) {
            final LinkedList categoryBuilders = new LinkedList();
            for (Object defId : definitions) {
                if (this.isDefinitionExcluded((String)defId)) continue;
                this.clientFactoryServices.newDefinition((String)defId, new ServiceCallback<Object>(){

                    public void onSuccess(Object definition) {
                        String id = DefinitionSetPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getId(definition);
                        String category = DefinitionSetPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getCategory(definition);
                        String categoryId = DefinitionSetPaletteBuilderImpl.this.toValidId(category);
                        if (!DefinitionSetPaletteBuilderImpl.this.isCategoryExcluded(categoryId)) {
                            MorphDefinition morphDefinition;
                            DefinitionPaletteCategoryImpl.DefinitionPaletteCategoryBuilder categoryGroupBuilder = (DefinitionPaletteCategoryImpl.DefinitionPaletteCategoryBuilder)DefinitionSetPaletteBuilderImpl.this.getItemBuilder(categoryBuilders, categoryId);
                            if (null == categoryGroupBuilder) {
                                categoryGroupBuilder = (DefinitionPaletteCategoryImpl.DefinitionPaletteCategoryBuilder)((DefinitionPaletteCategoryImpl.DefinitionPaletteCategoryBuilder)((DefinitionPaletteCategoryImpl.DefinitionPaletteCategoryBuilder)new DefinitionPaletteCategoryImpl.DefinitionPaletteCategoryBuilder(categoryId).definitionId(DefinitionSetPaletteBuilderImpl.this.paletteCategoryProvider.getDefinitionId(categoryId)).title(DefinitionSetPaletteBuilderImpl.this.paletteCategoryProvider.getTitle(categoryId))).tooltip(DefinitionSetPaletteBuilderImpl.this.paletteCategoryProvider.getTitle(categoryId))).description(DefinitionSetPaletteBuilderImpl.this.paletteCategoryProvider.getDescription(categoryId));
                                categoryBuilders.add(categoryGroupBuilder);
                            }
                            boolean hasMorphBase = null != (morphDefinition = DefinitionSetPaletteBuilderImpl.this.definitionUtils.getMorphDefinition(definition));
                            DefinitionPaletteGroupImpl.DefinitionPaletteGroupBuilder morphGroupBuilder = null;
                            String morphDefault = null;
                            if (hasMorphBase) {
                                String morphBase = morphDefinition.getBase();
                                morphDefault = morphDefinition.getDefault();
                                String morphBaseId = DefinitionSetPaletteBuilderImpl.this.toValidId(morphBase);
                                morphGroupBuilder = (DefinitionPaletteGroupImpl.DefinitionPaletteGroupBuilder)categoryGroupBuilder.getItem(morphBaseId);
                                if (null == morphGroupBuilder) {
                                    morphGroupBuilder = (DefinitionPaletteGroupImpl.DefinitionPaletteGroupBuilder)((DefinitionPaletteGroupImpl.DefinitionPaletteGroupBuilder)((DefinitionPaletteGroupImpl.DefinitionPaletteGroupBuilder)new DefinitionPaletteGroupImpl.DefinitionPaletteGroupBuilder(morphBaseId).definitionId(morphDefault).title(DefinitionSetPaletteBuilderImpl.this.paletteMorphGroupProvider.getTitle(morphBase, morphDefinition))).description(DefinitionSetPaletteBuilderImpl.this.paletteMorphGroupProvider.getDescription(morphBase, morphDefinition))).tooltip(DefinitionSetPaletteBuilderImpl.this.paletteMorphGroupProvider.getTitle(morphBase, morphDefinition));
                                    categoryGroupBuilder.addItem(morphGroupBuilder);
                                }
                            }
                            String title = DefinitionSetPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getTitle(definition);
                            String description = DefinitionSetPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getDescription(definition);
                            DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder itemBuilder = (DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)((DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)((DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)new DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder(id).definitionId(id).title(title)).description(description)).tooltip(description);
                            if (null != morphGroupBuilder) {
                                if (null != morphDefault && morphDefault.equals(id)) {
                                    morphGroupBuilder.addItem(0, itemBuilder);
                                } else {
                                    morphGroupBuilder.addItem(itemBuilder);
                                }
                            } else {
                                categoryGroupBuilder.addItem(itemBuilder);
                            }
                        }
                    }

                    public void onError(ClientRuntimeError error) {
                        callback.onError((Object)error);
                    }
                });
            }
            if (!categoryBuilders.isEmpty()) {
                LinkedList<DefinitionPaletteCategory> categories = new LinkedList<DefinitionPaletteCategory>();
                for (DefinitionPaletteCategoryImpl.DefinitionPaletteCategoryBuilder builder : categoryBuilders) {
                    categories.add((DefinitionPaletteCategory)builder.build());
                }
                DefinitionSetPaletteImpl definitionPalette = new DefinitionSetPaletteImpl(categories, defSetId);
                callback.onSuccess((Object)definitionPalette);
            } else {
                callback.onError((Object)new ClientRuntimeError("No categories found."));
            }
        } else {
            callback.onError((Object)new ClientRuntimeError("Missing definition argument."));
        }
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }

    @Override
    public DefinitionSetPaletteBuilder setCategoryProvider(DefinitionSetPaletteBuilder.PaletteCategoryProvider categoryProvider) {
        this.paletteCategoryProvider = categoryProvider;
        return this;
    }

    @Override
    public DefinitionSetPaletteBuilder setMorphGroupProvider(DefinitionSetPaletteBuilder.PaletteMorphGroupProvider groupProvider) {
        this.paletteMorphGroupProvider = groupProvider;
        return this;
    }
}

