/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.components.palette.model.AbstractPaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPaletteBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionPaletteItemImpl;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionsPaletteImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.util.DefinitionUtils;

@Dependent
public class DefinitionsPaletteBuilderImpl
extends AbstractPaletteDefinitionBuilder<Iterable<String>, DefinitionsPalette, ClientRuntimeError>
implements DefinitionsPaletteBuilder {
    private final DefinitionUtils definitionUtils;
    private final ClientFactoryService clientFactoryServices;

    protected DefinitionsPaletteBuilderImpl() {
        this(null, null);
    }

    @Inject
    public DefinitionsPaletteBuilderImpl(DefinitionUtils definitionUtils, ClientFactoryService clientFactoryServices) {
        this.definitionUtils = definitionUtils;
        this.clientFactoryServices = clientFactoryServices;
    }

    public void build(Iterable<String> definitions, final PaletteDefinitionBuilder.Callback<DefinitionsPalette, ClientRuntimeError> callback) {
        if (null != definitions) {
            final LinkedList builders = new LinkedList();
            for (final String string : definitions) {
                if (this.isDefinitionExcluded(string)) continue;
                this.clientFactoryServices.newDefinition(string, new ServiceCallback<Object>(){

                    public void onSuccess(Object definition) {
                        String id = DefinitionsPaletteBuilderImpl.this.toValidId(string);
                        String title = DefinitionsPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getTitle(definition);
                        String description = DefinitionsPaletteBuilderImpl.this.getDefinitionManager().adapters().forDefinition().getDescription(definition);
                        DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder itemBuilder = (DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)((DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)((DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder)new DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder(id).definitionId(string).title(title)).description(description)).tooltip(description);
                        builders.add(itemBuilder);
                    }

                    public void onError(ClientRuntimeError error) {
                        callback.onError((Object)error);
                    }
                });
            }
            if (!builders.isEmpty()) {
                LinkedList<DefinitionPaletteItem> paletteItems = new LinkedList<DefinitionPaletteItem>();
                for (DefinitionPaletteItemImpl.DefinitionPaletteItemBuilder builder : builders) {
                    paletteItems.add(builder.build());
                }
                DefinitionsPaletteImpl definitionsPaletteImpl = new DefinitionsPaletteImpl((List<DefinitionPaletteItem>)paletteItems);
                callback.onSuccess((Object)definitionsPaletteImpl);
            } else {
                callback.onError((Object)new ClientRuntimeError("No categories found."));
            }
        } else {
            callback.onError((Object)new ClientRuntimeError("Missing definitions argument."));
        }
    }

    @Override
    public void buildFromDefinitionSet(String defintionSetId, PaletteDefinitionBuilder.Callback<DefinitionsPalette, ClientRuntimeError> callback) {
        Object defSet = this.getDefinitionManager().definitionSets().getDefinitionSetById(defintionSetId);
        Set definitions = this.getDefinitionManager().adapters().forDefinitionSet().getDefinitions(defSet);
        this.build(definitions, callback);
    }

    @Override
    public void buildFromPaletteItems(List<DefinitionPaletteItem> definitionPaletteItems, PaletteDefinitionBuilder.Callback<DefinitionsPalette, ClientRuntimeError> callback) {
        DefinitionsPaletteImpl result = new DefinitionsPaletteImpl(definitionPaletteItems);
        callback.onSuccess((Object)result);
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }
}

