/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.service;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.service.FactoryService;

@ApplicationScoped
public class ClientFactoryService {
    ClientFactoryManager clientFactoryManager;
    Caller<FactoryService> factoryServiceCaller;

    protected ClientFactoryService() {
    }

    @Inject
    public ClientFactoryService(ClientFactoryManager clientFactoryManager, Caller<FactoryService> factoryServiceCaller) {
        this.clientFactoryManager = clientFactoryManager;
        this.factoryServiceCaller = factoryServiceCaller;
    }

    public <T> void newDefinition(String definitionId, final ServiceCallback<T> callback) {
        Object def = this.clientFactoryManager.newDefinition(definitionId);
        if (null != def) {
            callback.onSuccess(def);
        } else {
            ((FactoryService)this.factoryServiceCaller.call(new RemoteCallback<T>(){

                public void callback(T t) {
                    callback.onSuccess(t);
                }
            }, (message, throwable) -> {
                callback.onError(new ClientRuntimeError(throwable));
                return false;
            })).newDefinition(definitionId);
        }
    }

    public <T> void newDefinition(Class<T> type, final ServiceCallback<T> callback) {
        Object def = this.clientFactoryManager.newDefinition(type);
        if (null != def) {
            callback.onSuccess(def);
        } else {
            ((FactoryService)this.factoryServiceCaller.call(new RemoteCallback<T>(){

                public void callback(T t) {
                    callback.onSuccess(t);
                }
            }, (message, throwable) -> {
                callback.onError(new ClientRuntimeError(throwable));
                return false;
            })).newDefinition(type);
        }
    }

    public <T> void newElement(String uuid, String definitionId, final ServiceCallback<Element> callback) {
        Element element = this.clientFactoryManager.newElement(uuid, definitionId);
        if (null != element) {
            callback.onSuccess((Object)element);
        } else {
            ((FactoryService)this.factoryServiceCaller.call((RemoteCallback)new RemoteCallback<Element>(){

                public void callback(Element t) {
                    callback.onSuccess((Object)t);
                }
            }, (message, throwable) -> {
                callback.onError(new ClientRuntimeError(throwable));
                return false;
            })).newElement(uuid, definitionId);
        }
    }

    public <T> void newElement(String uuid, Class<T> type, final ServiceCallback<Element> callback) {
        Element element = this.clientFactoryManager.newElement(uuid, type);
        if (null != element) {
            callback.onSuccess((Object)element);
        } else {
            ((FactoryService)this.factoryServiceCaller.call((RemoteCallback)new RemoteCallback<Element>(){

                public void callback(Element t) {
                    callback.onSuccess((Object)t);
                }
            }, (message, throwable) -> {
                callback.onError(new ClientRuntimeError(throwable));
                return false;
            })).newElement(uuid, type);
        }
    }

    public <M extends Metadata, D extends Diagram> void newDiagram(String uuid, String id, M metadata, final ServiceCallback<D> callback) {
        Diagram diagram = this.clientFactoryManager.newDiagram(uuid, id, metadata);
        if (null != diagram) {
            callback.onSuccess((Object)diagram);
        } else {
            ((FactoryService)this.factoryServiceCaller.call(new RemoteCallback<D>(){

                public void callback(D d) {
                    callback.onSuccess(d);
                }
            }, (message, throwable) -> {
                callback.onError(new ClientRuntimeError(throwable));
                return false;
            })).newDiagram(uuid, id, metadata);
        }
    }

    public <M extends Metadata, D extends Diagram> void newDiagram(String uuid, Class<?> type, M metadata, final ServiceCallback<D> callback) {
        Diagram diagram = this.clientFactoryManager.newDiagram(uuid, type, metadata);
        if (null != diagram) {
            callback.onSuccess((Object)diagram);
        } else {
            ((FactoryService)this.factoryServiceCaller.call(new RemoteCallback<D>(){

                public void callback(D d) {
                    callback.onSuccess(d);
                }
            }, (message, throwable) -> {
                callback.onError(new ClientRuntimeError(throwable));
                return false;
            })).newDiagram(uuid, type, metadata);
        }
    }

    public ClientFactoryManager getClientFactoryManager() {
        return this.clientFactoryManager;
    }
}

