/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.Session;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class ClearSessionCommand
extends AbstractClientSessionCommand<AbstractClientFullSession> {
    private static Logger LOGGER = Logger.getLogger(ClearSessionCommand.class.getName());
    private final CanvasCommandFactory canvasCommandFactory;
    private final SessionCommandManager sessionCommandManager;

    protected ClearSessionCommand() {
        this(null, null);
    }

    @Inject
    public ClearSessionCommand(CanvasCommandFactory canvasCommandFactory, @Session SessionCommandManager sessionCommandManager) {
        super(false);
        this.canvasCommandFactory = canvasCommandFactory;
        this.sessionCommandManager = sessionCommandManager;
    }

    @Override
    public AbstractClientSessionCommand<AbstractClientFullSession> bind(AbstractClientFullSession session) {
        super.bind(session);
        this.checkState();
        return this;
    }

    @Override
    public <T> void execute(ClientSessionCommand.Callback<T> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        CommandResult result = ((AbstractClientFullSession)this.getSession()).getCanvasCommandManager().execute((Object)((AbstractClientFullSession)this.getSession()).getCanvasHandler(), (Command)this.canvasCommandFactory.CLEAR_CANVAS());
        if (!CommandUtils.isError((CommandResult)result)) {
            this.cleanSessionRegistry();
        }
        callback.onSuccess(result);
    }

    private void cleanSessionRegistry() {
        LOGGER.log(Level.FINE, "Clear Session Command executed - Cleaning the session's command registry...");
        this.sessionCommandManager.getRegistry().clear();
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        this.checkState();
    }

    private void checkState() {
        this.setEnabled(this.getState());
        this.fire();
    }

    private boolean getState() {
        Graph graph;
        Object diagram;
        boolean doEnable = false;
        Object v0 = diagram = null != this.getSession() ? ((AbstractClientFullSession)this.getSession()).getCanvasHandler().getDiagram() : null;
        if (null != diagram && null != (graph = diagram.getGraph())) {
            boolean hasNodes;
            String rootUUID = diagram.getMetadata().getCanvasRootUUID();
            Iterable nodes = graph.nodes();
            boolean bl = hasNodes = null != nodes && nodes.iterator().hasNext();
            if (hasNodes) {
                Iterator nodesIt = nodes.iterator();
                Node node = (Node)nodesIt.next();
                doEnable = nodesIt.hasNext() ? true : null == rootUUID || !rootUUID.equals(node.getUUID());
            }
        }
        return doEnable;
    }
}

