/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSessionManager;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DeleteSelectionSessionCommand
extends AbstractClientSessionCommand<AbstractClientFullSession> {
    private static Logger LOGGER = Logger.getLogger(DeleteSelectionSessionCommand.class.getName());
    private final ClientSessionManager<?, ?, ?> clientSessionManager;
    private final CanvasCommandFactory canvasCommandFactory;

    protected DeleteSelectionSessionCommand() {
        this(null, null);
    }

    @Inject
    public DeleteSelectionSessionCommand(ClientSessionManager<?, ?, ?> clientSessionManager, CanvasCommandFactory canvasCommandFactory) {
        super(false);
        this.clientSessionManager = clientSessionManager;
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    public <T> void execute(ClientSessionCommand.Callback<T> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        if (null != ((AbstractClientFullSession)this.getSession()).getSelectionControl()) {
            AbstractCanvasHandler canvasHandler = ((AbstractClientFullSession)this.getSession()).getCanvasHandler();
            CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager = ((AbstractClientFullSession)this.getSession()).getCanvasCommandManager();
            SelectionControl<AbstractCanvasHandler, Element> selectionControl = ((AbstractClientFullSession)this.getSession()).getSelectionControl();
            Collection selectedItems = selectionControl.getSelectedItems();
            if (selectedItems != null && !selectedItems.isEmpty()) {
                selectedItems.stream().forEach(selectedItemUUID -> {
                    Node element = canvasHandler.getGraphIndex().getNode(selectedItemUUID);
                    if (element == null) {
                        element = canvasHandler.getGraphIndex().getEdge(selectedItemUUID);
                        if (element != null) {
                            this.log(Level.FINE, "Deleting edge with id " + element.getUUID());
                            canvasCommandManager.execute((Object)canvasHandler, (Command)this.canvasCommandFactory.DELETE_CONNECTOR((Edge)element));
                        }
                    } else {
                        this.log(Level.FINE, "Deleting node with id " + element.getUUID());
                        canvasCommandManager.execute((Object)canvasHandler, (Command)this.canvasCommandFactory.DELETE_NODE(element));
                    }
                });
            } else {
                this.log(Level.FINE, "Cannot delete element, no element selected on canvas.");
            }
            callback.onSuccess(null);
        }
    }

    void onKeyDownEvent(@Observes KeyDownEvent keyDownEvent) {
        boolean isSameSession;
        PortablePreconditions.checkNotNull((String)"keyDownEvent", (Object)keyDownEvent);
        KeyboardEvent.Key key = keyDownEvent.getKey();
        boolean isDeleteKey = null != key && KeyboardEvent.Key.DELETE.equals((Object)key);
        boolean bl = isSameSession = null != this.getSession() && ((AbstractClientFullSession)this.getSession()).equals(this.clientSessionManager.getCurrentSession());
        if (isDeleteKey && isSameSession) {
            this.execute(new ClientSessionCommand.Callback<Object>(){

                @Override
                public void onSuccess(Object result) {
                }

                @Override
                public void onError(ClientRuntimeError error) {
                    LOGGER.log(Level.SEVERE, "Error while trying to delete selected items. Message=[" + error.toString() + "]", error.getThrowable());
                }
            });
        }
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

