/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.stack.StackCommandManager;
import org.kie.workbench.common.stunner.core.command.util.RedoCommandHandler;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class RedoSessionCommand
extends AbstractClientSessionCommand<AbstractClientFullSession> {
    private final RedoCommandHandler<Command<AbstractCanvasHandler, CanvasViolation>> redoCommandHandler;

    protected RedoSessionCommand() {
        this(null);
    }

    @Inject
    public RedoSessionCommand(RedoCommandHandler<Command<AbstractCanvasHandler, CanvasViolation>> redoCommandHandler) {
        super(false);
        this.redoCommandHandler = redoCommandHandler;
    }

    @Override
    public <T> void execute(ClientSessionCommand.Callback<T> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        StackCommandManager<AbstractCanvasHandler, CanvasViolation> scm = this.getStackCommandManager();
        CommandResult result = this.redoCommandHandler.execute((Object)((AbstractClientFullSession)this.getSession()).getCanvasHandler(), scm);
        this.checkState();
        callback.onSuccess(result);
    }

    @Override
    public void unbind() {
        super.unbind();
        this.redoCommandHandler.clear();
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        if (null != commandExecutedEvent.getCommand()) {
            this.redoCommandHandler.onCommandExecuted(commandExecutedEvent.getCommand());
        }
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        if (null != commandUndoExecutedEvent.getCommand()) {
            this.redoCommandHandler.onUndoCommandExecuted(commandUndoExecutedEvent.getCommand());
        }
        this.checkState();
    }

    private void checkState() {
        this.setEnabled(null != this.getSession() && this.redoCommandHandler.isEnabled());
        this.fire();
    }

    private StackCommandManager<AbstractCanvasHandler, CanvasViolation> getStackCommandManager() {
        try {
            return (StackCommandManager)((AbstractClientFullSession)this.getSession()).getCanvasCommandManager();
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

