/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.command.stack.StackCommandManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class RefreshSessionCommand
extends AbstractClientSessionCommand<AbstractClientFullSession> {
    private static Logger LOGGER = Logger.getLogger(RefreshSessionCommand.class.getName());
    private final ClientDiagramService clientDiagramService;

    protected RefreshSessionCommand() {
        this(null);
    }

    @Inject
    public RefreshSessionCommand(ClientDiagramService clientDiagramService) {
        super(false);
        this.clientDiagramService = clientDiagramService;
    }

    @Override
    public <T> void execute(final ClientSessionCommand.Callback<T> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        final Path path = this.getDiagramPath();
        LOGGER.log(Level.FINE, "Refreshing diagram for path [" + path + "]...");
        ((AbstractClientFullSession)this.getSession()).getCanvasHandler().clear();
        this.clientDiagramService.getByPath(path, new ServiceCallback<Diagram>(){

            public void onSuccess(Diagram diagram) {
                LOGGER.log(Level.FINE, "Refreshing diagram for path [" + path + "]...");
                ((AbstractClientFullSession)RefreshSessionCommand.this.getSession()).getCanvasHandler().draw(diagram);
                callback.onSuccess(diagram);
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.SEVERE, "Error when loading diagram for path [" + path + "]", error.getThrowable());
                callback.onError(error);
            }
        });
        this.checkState();
    }

    private Path getDiagramPath() {
        return null != this.getSession() ? ((AbstractClientFullSession)this.getSession()).getCanvasHandler().getDiagram().getMetadata().getPath() : null;
    }

    private void checkState() {
        this.setEnabled(this.hasSessionCommands());
        this.fire();
    }

    private StackCommandManager<AbstractCanvasHandler, CanvasViolation> getStackCommandManager() {
        try {
            return (StackCommandManager)((AbstractClientFullSession)this.getSession()).getCanvasCommandManager();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private boolean hasSessionCommands() {
        return null != this.getSession() && null != this.getStackCommandManager() && !this.getStackCommandManager().getRegistry().isEmpty();
    }
}

