/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.stack.StackCommandManager;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class UndoSessionCommand
extends AbstractClientSessionCommand<AbstractClientFullSession> {
    public UndoSessionCommand() {
        super(false);
    }

    @Override
    public <T> void execute(ClientSessionCommand.Callback<T> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        StackCommandManager<AbstractCanvasHandler, CanvasViolation> scm = this.getStackCommandManager();
        if (null != scm) {
            CommandResult result = this.getStackCommandManager().undo((Object)((AbstractClientFullSession)this.getSession()).getCanvasHandler());
            this.checkState();
            callback.onSuccess(result);
        }
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        this.checkState();
    }

    private void checkState() {
        if (null != this.getSession()) {
            StackCommandManager<AbstractCanvasHandler, CanvasViolation> canvasCommManager = this.getStackCommandManager();
            boolean isHistoryEmpty = canvasCommManager == null || canvasCommManager.getRegistry().getCommandHistory().isEmpty();
            this.setEnabled(!isHistoryEmpty);
        } else {
            this.setEnabled(false);
        }
        this.fire();
    }

    private StackCommandManager<AbstractCanvasHandler, CanvasViolation> getStackCommandManager() {
        try {
            return (StackCommandManager)((AbstractClientFullSession)this.getSession()).getCanvasCommandManager();
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

