/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.session.ClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractClientReadOnlySession
extends AbstractClientSession
implements ClientReadOnlySession<AbstractCanvas, AbstractCanvasHandler> {
    private SelectionControl<AbstractCanvasHandler, Element> selectionControl;
    private ZoomControl<AbstractCanvas> zoomControl;
    private PanControl<AbstractCanvas> panControl;
    private CanvasShapeListener shapeListener;
    private CanvasElementListener elementListener;

    public AbstractClientReadOnlySession(AbstractCanvas canvas, AbstractCanvasHandler canvasHandler, SelectionControl<AbstractCanvasHandler, Element> selectionControl, ZoomControl<AbstractCanvas> zoomControl, PanControl<AbstractCanvas> panControl) {
        super(canvas, canvasHandler);
        this.selectionControl = selectionControl;
        this.zoomControl = zoomControl;
        this.panControl = panControl;
    }

    public SelectionControl<AbstractCanvasHandler, Element> getSelectionControl() {
        return this.selectionControl;
    }

    public ZoomControl<AbstractCanvas> getZoomControl() {
        return this.zoomControl;
    }

    public PanControl<AbstractCanvas> getPanControl() {
        return this.panControl;
    }

    @Override
    protected void doOpen() {
        this.initializeListeners();
        this.enableControls();
    }

    @Override
    public void doDispose() {
        this.removeListeners();
        this.disableControls();
    }

    @Override
    protected void doPause() {
    }

    @Override
    protected void doResume() {
    }

    private void initializeListeners() {
        Canvas canvas = this.getCanvasHandler().getCanvas();
        this.shapeListener = new CanvasShapeListener(){

            public void register(Shape item) {
                AbstractClientReadOnlySession.this.onRegisterShape(item);
            }

            public void deregister(Shape item) {
                AbstractClientReadOnlySession.this.onDeregisterShape(item);
            }

            public void clear() {
                AbstractClientReadOnlySession.this.onClear();
            }
        };
        canvas.addRegistrationListener(this.shapeListener);
        this.elementListener = new CanvasElementListener(){

            public void update(Element item) {
                AbstractClientReadOnlySession.this.onElementRegistration(item, false, true);
            }

            public void register(Element item) {
                AbstractClientReadOnlySession.this.onRegisterElement(item);
            }

            public void deregister(Element item) {
                AbstractClientReadOnlySession.this.onDeregisterElement(item);
            }

            public void clear() {
                AbstractClientReadOnlySession.this.onClear();
            }
        };
        this.getCanvasHandler().addRegistrationListener(this.elementListener);
    }

    private void removeListeners() {
        if (null != this.shapeListener) {
            this.getCanvas().removeRegistrationListener(this.shapeListener);
        }
        if (null != this.elementListener) {
            this.getCanvasHandler().removeRegistrationListener(this.elementListener);
        }
    }

    private void onRegisterShape(Shape shape) {
        this.onShapeRegistration(shape, true);
    }

    private void onDeregisterShape(Shape shape) {
        this.onShapeRegistration(shape, false);
    }

    private void onRegisterElement(Element element) {
        this.onElementRegistration(element, true, false);
    }

    private void onDeregisterElement(Element element) {
        this.onElementRegistration(element, false, false);
    }

    protected void onElementRegistration(Element element, boolean add, boolean update) {
        if (update) {
            this.fireRegistrationUpdateListeners((CanvasControl<AbstractCanvasHandler>)this.getSelectionControl(), element);
        } else {
            this.fireRegistrationListeners((CanvasControl<AbstractCanvasHandler>)this.getSelectionControl(), element, add);
        }
    }

    protected void onShapeRegistration(Shape shape, boolean add) {
        this.fireRegistrationListeners((CanvasControl<AbstractCanvas>)this.getZoomControl(), shape, add);
        this.fireRegistrationListeners((CanvasControl<AbstractCanvas>)this.getPanControl(), shape, add);
    }

    protected void onClear() {
        this.fireRegistrationClearListeners((CanvasControl<AbstractCanvasHandler>)this.getSelectionControl());
    }

    protected void enableControls() {
        this.enableControl((CanvasControl<AbstractCanvasHandler>)this.getSelectionControl(), this.getCanvasHandler());
        this.enableControl((CanvasControl<AbstractCanvas>)this.getZoomControl(), this.getCanvas());
        this.enableControl((CanvasControl<AbstractCanvas>)this.getPanControl(), this.getCanvas());
    }

    protected void disableControls() {
        if (null != this.getSelectionControl()) {
            this.getSelectionControl().disable();
        }
        if (null != this.getZoomControl()) {
            this.getZoomControl().disable();
        }
        if (null != this.getPanControl()) {
            this.getPanControl().disable();
        }
    }
}

