/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistationControl;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractClientSession
implements ClientSession<AbstractCanvas, AbstractCanvasHandler> {
    private final transient AbstractCanvas canvas;
    private final transient AbstractCanvasHandler canvasHandler;
    private final transient String uuid = UUID.uuid();
    boolean isOpened;

    public AbstractClientSession(AbstractCanvas canvas, AbstractCanvasHandler canvasHandler) {
        this.canvas = canvas;
        this.canvasHandler = canvasHandler;
        this.isOpened = false;
    }

    protected abstract void doOpen();

    protected abstract void doPause();

    protected abstract void doResume();

    protected abstract void doDispose();

    public void open() {
        this.doOpen();
        this.isOpened = true;
    }

    public void pause() {
        if (!this.isOpened) {
            throw new IllegalStateException("Session cannot be paused as it has been not opened yet.");
        }
        this.doPause();
    }

    public void resume() {
        if (!this.isOpened) {
            throw new IllegalStateException("Session cannot be resumed as it has been not opened yet.");
        }
        this.doResume();
    }

    public void dispose() {
        if (!this.isOpened) {
            throw new IllegalStateException("Session cannot be disposed as it has been not opened yet.");
        }
        this.doDispose();
        this.canvasHandler.destroy();
        this.isOpened = false;
    }

    public AbstractCanvas getCanvas() {
        return this.canvas;
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    protected void enableControl(CanvasControl<AbstractCanvasHandler> control, AbstractCanvasHandler handler) {
        if (null != control) {
            control.enable((Object)handler);
        }
    }

    protected void enableControl(CanvasControl<AbstractCanvas> control, AbstractCanvas handler) {
        if (null != control) {
            control.enable((Object)handler);
        }
    }

    protected void fireRegistrationListeners(CanvasControl<AbstractCanvasHandler> control, Element element, boolean add) {
        if (null != control && null != element && control instanceof CanvasRegistationControl) {
            CanvasRegistationControl registationControl = (CanvasRegistationControl)control;
            if (add) {
                registationControl.register((Object)element);
            } else {
                registationControl.deregister((Object)element);
            }
        }
    }

    protected void fireRegistrationListeners(CanvasControl<AbstractCanvas> control, Shape shape, boolean add) {
        if (null != control && null != shape && control instanceof CanvasRegistationControl) {
            CanvasRegistationControl registationControl = (CanvasRegistationControl)control;
            if (add) {
                registationControl.register((Object)shape);
            } else {
                registationControl.deregister((Object)shape);
            }
        }
    }

    protected void fireRegistrationUpdateListeners(CanvasControl<AbstractCanvasHandler> control, Element element) {
        if (null != control && null != element && control instanceof AbstractCanvasHandlerRegistrationControl) {
            AbstractCanvasHandlerRegistrationControl registationControl = (AbstractCanvasHandlerRegistrationControl)control;
            registationControl.update(element);
        }
    }

    protected void fireRegistrationClearListeners(CanvasControl<AbstractCanvasHandler> control) {
        if (null != control && control instanceof AbstractCanvasHandlerRegistrationControl) {
            AbstractCanvasHandlerRegistrationControl registationControl = (AbstractCanvasHandlerRegistrationControl)control;
            registationControl.deregisterAll();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractClientSession)) {
            return false;
        }
        AbstractClientSession that = (AbstractClientSession)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [uuid=" + this.uuid + "]";
    }
}

