/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSessionManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;

public abstract class AbstractClientSessionManager
implements ClientSessionManager<AbstractCanvas, AbstractCanvasHandler, AbstractClientSession> {
    private static Logger LOGGER = Logger.getLogger(AbstractClientSessionManager.class.getName());
    AbstractClientSession current;

    protected abstract void postOpen();

    protected abstract void postPause();

    protected abstract void postResume();

    protected abstract void postDispose();

    public AbstractClientSession getCurrentSession() {
        return this.current;
    }

    public void open(AbstractClientSession session) {
        if (null != this.current && !session.equals(this.current)) {
            this.pause();
        }
        if (!session.equals(this.current)) {
            this.log(Level.FINE, "Opening session [" + session.toString() + "] ...");
            this.current = session;
            this.current.open();
            this.postOpen();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] opened");
        }
    }

    public void pause() {
        if (null != this.current) {
            this.log(Level.FINE, "Pausing session [" + this.current.toString() + "] ...");
            this.current.pause();
            this.postPause();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] paused");
        }
    }

    public void resume(AbstractClientSession session) {
        if (null != this.current && !this.current.equals(session)) {
            this.pause();
        }
        if (!session.equals(this.current)) {
            this.log(Level.FINE, "Resuming session [" + session.toString() + "] ...");
            this.current = session;
            this.current.resume();
            this.postResume();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] resumed");
        }
    }

    public void dispose() {
        if (null != this.current) {
            this.log(Level.FINE, "Disposing session [" + this.current.toString() + "] ...");
            this.current.dispose();
            this.postDispose();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] disposed");
            this.current = null;
        }
    }

    public void handleCommandError(CommandException ce) {
        this.log(Level.SEVERE, "Command execution failed", (Throwable)ce);
    }

    public void handleClientError(ClientRuntimeError error) {
        this.log(Level.SEVERE, "An error on client side happened", error.getThrowable());
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    private void log(Level level, String message, Throwable t) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message, t);
        }
    }
}

