/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.platform.ClientPlatform;
import org.kie.workbench.common.stunner.core.client.api.platform.PlatformManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDisposedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionPausedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionResumedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSessionProducer;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;

@ApplicationScoped
public class ClientSessionManagerImpl
extends AbstractClientSessionManager {
    private static Logger LOGGER = Logger.getLogger(ClientSessionManagerImpl.class.getName());
    private final PlatformManager platformManager;
    private final Event<SessionOpenedEvent> sessionOpenedEvent;
    private final Event<SessionPausedEvent> sessionPausedEvent;
    private final Event<SessionResumedEvent> sessionResumedEvent;
    private final Event<SessionDisposedEvent> sessionDisposedEvent;
    private final Event<OnSessionErrorEvent> sessionErrorEvent;

    protected ClientSessionManagerImpl() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public ClientSessionManagerImpl(PlatformManager platformManager, Event<SessionOpenedEvent> sessionOpenedEvent, Event<SessionDisposedEvent> sessionDisposedEvent, Event<SessionPausedEvent> sessionPausedEvent, Event<SessionResumedEvent> sessionResumedEvent, Event<OnSessionErrorEvent> sessionErrorEvent) {
        this.platformManager = platformManager;
        this.sessionOpenedEvent = sessionOpenedEvent;
        this.sessionPausedEvent = sessionPausedEvent;
        this.sessionResumedEvent = sessionResumedEvent;
        this.sessionDisposedEvent = sessionDisposedEvent;
        this.sessionErrorEvent = sessionErrorEvent;
    }

    @Override
    protected void postOpen() {
        this.sessionOpenedEvent.fire((Object)new SessionOpenedEvent((ClientSession)this.current));
    }

    @Override
    protected void postPause() {
        this.sessionPausedEvent.fire((Object)new SessionPausedEvent((ClientSession)this.current));
    }

    @Override
    protected void postResume() {
        this.sessionResumedEvent.fire((Object)new SessionResumedEvent((ClientSession)this.current));
    }

    @Override
    protected void postDispose() {
        this.sessionDisposedEvent.fire((Object)new SessionDisposedEvent((ClientSession)this.current));
    }

    public ClientReadOnlySession<AbstractCanvas, AbstractCanvasHandler> newReadOnlySession() {
        ClientPlatform platform = this.getPlatform();
        ClientReadOnlySession session = null;
        if (platform instanceof AbstractClientSessionProducer) {
            AbstractClientSessionProducer sessionProducer = (AbstractClientSessionProducer)platform;
            session = sessionProducer.newReadOnlySession();
        }
        return session;
    }

    public ClientFullSession<AbstractCanvas, AbstractCanvasHandler> newFullSession() {
        ClientPlatform platform = this.getPlatform();
        ClientFullSession session = null;
        if (platform instanceof AbstractClientSessionProducer) {
            AbstractClientSessionProducer sessionProducer = (AbstractClientSessionProducer)platform;
            session = sessionProducer.newFullSession();
        }
        return session;
    }

    @Override
    public void handleCommandError(CommandException ce) {
        super.handleCommandError(ce);
        this.sessionErrorEvent.fire((Object)new OnSessionErrorEvent((ClientSession)this.current, new ClientRuntimeError("Error while executing command.", (Throwable)ce)));
    }

    @Override
    public void handleClientError(ClientRuntimeError error) {
        super.handleClientError(error);
        this.sessionErrorEvent.fire((Object)new OnSessionErrorEvent((ClientSession)this.current, error));
    }

    protected ClientPlatform getPlatform() {
        return this.platformManager.getCurrentPlatform();
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

