/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape;

import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.client.shape.AbstractShape;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public abstract class AbstractCompositeShape<W, E extends Node<View<W>, Edge>, V extends ShapeView>
extends AbstractShape<W, E, V>
implements HasChildren<AbstractShape<W, Node<View<W>, Edge>, ?>> {
    private final List<AbstractShape<W, Node<View<W>, Edge>, ?>> children = new LinkedList();

    public AbstractCompositeShape(V view) {
        super(view);
    }

    public void addChild(AbstractShape<W, Node<View<W>, Edge>, ?> child, HasChildren.Layout layout) {
        HasChildren view = (HasChildren)this.getShapeView();
        this.children.add(child);
        view.addChild(child.getShapeView(), layout);
    }

    public void removeChild(AbstractShape<W, Node<View<W>, Edge>, ?> child) {
        HasChildren view = (HasChildren)this.getShapeView();
        this.children.remove(child);
        view.removeChild(child.getShapeView());
    }

    public Iterable<AbstractShape<W, Node<View<W>, Edge>, ?>> getChildren() {
        return this.children;
    }

    @Override
    public void applyProperties(E element, MutationContext mutationContext) {
        super.applyProperties(element, mutationContext);
        for (AbstractShape<W, Node<View<W>, Edge>, ?> child : this.children) {
            child.applyProperties((Node<View<W>, Edge>)element, mutationContext);
        }
    }

    @Override
    public void applyProperty(E element, String propertyId, Object value, MutationContext mutationContext) {
        super.applyProperty(element, propertyId, value, mutationContext);
        for (AbstractShape<W, Node<View<W>, Edge>, ?> child : this.children) {
            child.applyProperty((Node<View<W>, Edge>)element, propertyId, value, mutationContext);
        }
    }

    @Override
    protected void doDestroy() {
        if (!this.children.isEmpty()) {
            for (AbstractShape<W, Node<View<W>, Edge>, ?> child : this.children) {
                child.destroy();
            }
        }
        this.children.clear();
    }
}

