/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public abstract class AbstractConnector<W, E extends Edge<ViewConnector<W>, Node>, V extends ShapeView>
implements EdgeShape<W, ViewConnector<W>, E, V>,
Lifecycle {
    private static Logger LOGGER = Logger.getLogger(AbstractConnector.class.getName());
    protected String uuid;
    protected V view;

    public AbstractConnector(V view) {
        this.view = view;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public V getShapeView() {
        return this.view;
    }

    public void beforeDraw() {
    }

    public void afterDraw() {
    }

    public void applyPosition(E element, MutationContext mutationContext) {
    }

    public void applyProperties(E element, MutationContext mutationContext) {
    }

    public void applyProperty(E element, String propertyId, Object value, MutationContext mutationContext) {
    }

    public void destroy() {
        this.view.destroy();
    }

    protected void _applyFillColor(String color, MutationContext mutationContext) {
        if (color != null && color.trim().length() > 0) {
            this.getShapeView().setFillColor(color);
        }
    }

    protected void _applyFillAlpha(double alpha, MutationContext mutationContext) {
        this.getShapeView().setFillAlpha(alpha);
    }

    protected void _applyBorders(String color, Double width, MutationContext mutationContext) {
        boolean isAnimation = this.isAnimationMutation(mutationContext);
        if (color != null && color.trim().length() > 0) {
            this._applyBorderColor(color, mutationContext);
        }
        if (width != null) {
            this._applyBorderWidth(width, mutationContext);
        }
    }

    protected void _applyBorderColor(String color, MutationContext mutationContext) {
        this.getShapeView().setStrokeColor(color);
    }

    protected void _applyBorderWidth(double width, MutationContext mutationContext) {
        this.getShapeView().setStrokeWidth(width);
    }

    protected void _applyBorderAlpha(double alpha, MutationContext mutationContext) {
        this.getShapeView().setStrokeAlpha(alpha);
    }

    public void applyConnections(E element, ShapeView<?> source, ShapeView<?> target, MutationContext mutationContext) {
        ViewConnector connectionContent = (ViewConnector)element.getContent();
        int sourceMagnet = connectionContent.getSourceMagnetIndex();
        int targetMagnet = connectionContent.getTargetMagnetIndex();
        if (null != source) {
            int z = source.getZIndex();
            this.view.setZIndex(z);
        }
        if (null != source && null != target) {
            ((IsConnector)this.view).connect(source, sourceMagnet, target, targetMagnet, true, false);
        }
    }

    protected boolean isStaticMutation(MutationContext mutationContext) {
        return ShapeUtils.isStaticMutation(mutationContext);
    }

    protected boolean isAnimationMutation(MutationContext mutationContext) {
        return ShapeUtils.isAnimationMutation(this.view, mutationContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractConnector)) {
            return false;
        }
        AbstractConnector that = (AbstractConnector)o;
        return this.uuid != null && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

