/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape;

import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.NodeShape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public abstract class AbstractShape<W, E extends Node<View<W>, Edge>, V extends ShapeView>
implements NodeShape<W, View<W>, E, V>,
Lifecycle {
    private static Logger LOGGER = Logger.getLogger(AbstractShape.class.getName());
    private String uuid;
    private V view;

    public AbstractShape(V view) {
        this.view = view;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public V getShapeView() {
        return this.view;
    }

    public void beforeDraw() {
    }

    public void afterDraw() {
        if (this.view instanceof HasTitle) {
            ((HasTitle)this.view).moveTitleToTop();
        }
    }

    public void applyPosition(E element, MutationContext mutationContext) {
        Double[] position = GraphUtils.getPosition((View)((View)element.getContent()));
        double x = position[0];
        double y = position[1];
        this.view.setShapeX(x);
        this.view.setShapeY(y);
    }

    public void applyProperties(E element, MutationContext mutationContext) {
        this._applyElementName(element, mutationContext);
    }

    public void applyProperty(E element, String propertyId, Object value, MutationContext mutationContext) {
    }

    protected void applyFillColor(String color, MutationContext mutationContext) {
        if (color != null && color.trim().length() > 0) {
            boolean hasGradient = this.view instanceof HasFillGradient;
            if (!hasGradient) {
                this.view.setFillColor(color);
            } else {
                ((HasFillGradient)this.view).setFillGradient(HasFillGradient.Type.LINEAR, color, "#FFFFFF");
            }
        }
    }

    protected void applyFillAlpha(Double alpha, MutationContext mutationContext) {
        if (null != alpha) {
            this.view.setFillAlpha(alpha.doubleValue());
        }
    }

    protected void applyBorders(String color, Double width, MutationContext mutationContext) {
        if (color != null && color.trim().length() > 0) {
            this.view.setStrokeColor(color);
        }
        if (width != null) {
            this.view.setStrokeWidth(width.doubleValue());
        }
    }

    protected void applyBorderAlpha(Double alpha, MutationContext mutationContext) {
        if (null != alpha) {
            this.view.setStrokeAlpha(alpha.doubleValue());
        }
    }

    protected void applyFont(String family, String color, Double size, Double borderSize, Double alpha, MutationContext mutationContext) {
        if (this.view instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)this.view;
            if (family != null && family.trim().length() > 0) {
                hasTitle.setTitleFontFamily(family);
            }
            if (color != null && color.trim().length() > 0) {
                hasTitle.setTitleStrokeColor(color);
            }
            if (size != null && size > 0.0) {
                hasTitle.setTitleFontSize(size.doubleValue());
            }
            this.applyFontAlpha(hasTitle, alpha, mutationContext);
            if (borderSize != null && borderSize > 0.0) {
                hasTitle.setTitleStrokeWidth(borderSize.doubleValue());
            }
            hasTitle.refreshTitle();
        }
    }

    protected void applyFontAlpha(HasTitle hasTitle, Double alpha, MutationContext mutationContext) {
        if (null != alpha) {
            hasTitle.setTitleAlpha(alpha.doubleValue());
        }
    }

    protected void applySize(HasSize hasSize, double width, double height, MutationContext mutationContext) {
        hasSize.setSize(width, height);
    }

    protected void applyRadius(HasRadius hasRadius, double radius, MutationContext mutationContext) {
        if (radius > 0.0) {
            hasRadius.setRadius(radius);
        }
    }

    protected String getNamePropertyValue(E element) {
        return null;
    }

    protected void _applyElementName(E element, MutationContext mutationContext) {
        if (this.view instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)this.view;
            String name = this.getNamePropertyValue(element);
            hasTitle.setTitle(name);
            hasTitle.refreshTitle();
        }
    }

    protected abstract void doDestroy();

    public void destroy() {
        this.doDestroy();
        this.view.destroy();
    }

    protected boolean isStaticMutation(MutationContext mutationContext) {
        return ShapeUtils.isStaticMutation(mutationContext);
    }

    protected boolean isAnimationMutation(MutationContext mutationContext) {
        return ShapeUtils.isAnimationMutation(this.view, mutationContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractShape)) {
            return false;
        }
        AbstractShape that = (AbstractShape)o;
        return this.uuid != null && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }
}

