/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.factory;

import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.AbstractShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.CompositeShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;

public abstract class AbstractCompositeShapeFactory<W, S extends Shape>
extends AbstractShapeFactory<W, S>
implements CompositeShapeFactory<W, AbstractCanvasHandler, S, ShapeFactory<W, AbstractCanvasHandler, S>> {
    protected final List<ShapeFactory<W, AbstractCanvasHandler, S>> factories = new LinkedList<ShapeFactory<W, AbstractCanvasHandler, S>>();
    DefinitionManager definitionManager;

    private AbstractCompositeShapeFactory() {
    }

    public AbstractCompositeShapeFactory(DefinitionManager definitionManager) {
        this.definitionManager = definitionManager;
    }

    public void addFactory(ShapeFactory<W, AbstractCanvasHandler, S> factory) {
        this.factories.add(factory);
    }

    public boolean accepts(String definitionId) {
        for (ShapeFactory<W, AbstractCanvasHandler, S> factory : this.factories) {
            if (!factory.accepts(definitionId)) continue;
            return true;
        }
        return false;
    }

    public String getDescription(String definitionId) {
        for (ShapeFactory<W, AbstractCanvasHandler, S> factory : this.factories) {
            if (!factory.accepts(definitionId)) continue;
            return factory.getDescription(definitionId);
        }
        throw new RuntimeException("This factory supports Definition [" + definitionId + "] but cannot obtain the description for it.");
    }

    public S build(W definition, AbstractCanvasHandler context) {
        String id = this.definitionManager.adapters().forDefinition().getId(definition);
        for (ShapeFactory<W, AbstractCanvasHandler, S> factory : this.factories) {
            if (!factory.accepts(id)) continue;
            return (S)factory.build(definition, (Object)context);
        }
        throw new RuntimeException("This factory supports Definition [" + id + "] but cannot build the sthape for it.");
    }

    public Glyph glyph(String definitionId, double width, double height) {
        for (ShapeFactory<W, AbstractCanvasHandler, S> factory : this.factories) {
            if (!factory.accepts(definitionId)) continue;
            return factory.glyph(definitionId, width, height);
        }
        throw new RuntimeException("This factory supports Definition [" + definitionId + "] but cannot obtain the description for it.");
    }
}

