/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.AbstractBindableShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;

public abstract class AbstractShapeDefFactory<W, V extends ShapeView, S extends Shape<V>, P extends ShapeDef<W>>
extends AbstractBindableShapeFactory<W, S>
implements ShapeDefFactory<W, AbstractCanvasHandler, S, P> {
    protected final Map<Class<?>, P> definitions = new HashMap();
    protected final DefinitionManager definitionManager;
    protected final FactoryManager factoryManager;

    public AbstractShapeDefFactory(DefinitionManager definitionManager, FactoryManager factoryManager) {
        this.definitionManager = definitionManager;
        this.factoryManager = factoryManager;
    }

    @Override
    public Set<Class<?>> getSupportedModelClasses() {
        return this.definitions.keySet();
    }

    @Override
    public String getDescription(String definitionId) {
        P proxy = this.getShapeDef(definitionId);
        Object tempObject = this.factoryManager.newDefinition(definitionId);
        return this.definitionManager.adapters().forDefinition().getDescription(tempObject);
    }

    @Override
    protected String getDescription(Class<?> clazz) {
        String id = this.getDefinitionId(clazz);
        return this.getDescription(id);
    }

    public void addShapeDef(Class<?> clazz, P proxy) {
        this.definitions.put(clazz, proxy);
    }

    public P getShapeDef(Class<?> clazz) {
        return (P)((ShapeDef)this.definitions.get(clazz));
    }

    public P getShapeDef(String definitionId) {
        for (Map.Entry<Class<?>, P> entry : this.definitions.entrySet()) {
            String id = BindableAdapterUtils.getDefinitionId(entry.getKey());
            if (!id.equals(definitionId)) continue;
            return (P)((ShapeDef)entry.getValue());
        }
        throw new RuntimeException("This factory should provide a def for Definition [" + definitionId + "]");
    }

    @Override
    public Glyph glyph(String definitionId, double width, double height) {
        Class<?> clazz = this.getDefinitionClass(definitionId);
        return this.glyph(clazz, width, height);
    }
}

