/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.api;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSessionFactory;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.commons.validation.PortablePreconditions;

public abstract class AbstractClientSessionManager
implements SessionManager {
    private static Logger LOGGER = Logger.getLogger(AbstractClientSessionManager.class.getName());
    ClientSession current;

    protected abstract <D extends Diagram> List<ClientSessionFactory<?>> getFactories(D var1);

    protected abstract void postOpen();

    protected abstract void postPause();

    protected abstract void postResume();

    protected abstract void postDestroy();

    public <D extends Diagram, S extends ClientSession> ClientSessionFactory<S> getSessionFactory(D diagram, Class<S> sessionType) {
        return this.getFactories(diagram).stream().filter(f -> f.getSessionType().equals(sessionType)).findFirst().orElse(null);
    }

    public <S extends ClientSession> S getCurrentSession() {
        return (S)this.current;
    }

    public <S extends ClientSession> void open(S session) {
        PortablePreconditions.checkNotNull((String)"session", session);
        if (null != this.current && !session.equals(this.current)) {
            this.pause();
        }
        if (!session.equals(this.current)) {
            this.log(Level.FINE, "Opening session [" + session.toString() + "] ...");
            this.current = session;
            this.getCurrentAbstractSession().open();
            this.postOpen();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] opened");
        }
    }

    public void pause() {
        if (null != this.current) {
            this.log(Level.FINE, "Pausing session [" + this.current.toString() + "] ...");
            this.getCurrentAbstractSession().pause();
            this.postPause();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] paused");
        }
    }

    public <S extends ClientSession> void resume(S session) {
        PortablePreconditions.checkNotNull((String)"session", session);
        if (null != this.current && !this.current.equals(session)) {
            this.pause();
        }
        if (!session.equals(this.current)) {
            this.log(Level.FINE, "Resuming session [" + session.toString() + "] ...");
            this.current = session;
            this.getCurrentAbstractSession().resume();
            this.postResume();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] resumed");
        }
    }

    public void destroy() {
        if (null != this.current) {
            this.log(Level.FINE, "Disposing session [" + this.current.toString() + "] ...");
            this.getCurrentAbstractSession().destroy();
            this.postDestroy();
            this.log(Level.FINE, "Session [" + this.current.toString() + "] destroyed");
            this.current = null;
        }
    }

    public void handleCommandError(CommandException ce) {
        this.log(Level.SEVERE, "Command execution failed", ce);
    }

    public void handleClientError(ClientRuntimeError error) {
        this.log(Level.SEVERE, "An error on client side happened", error.getThrowable());
    }

    protected AbstractClientSession getCurrentAbstractSession() {
        return (AbstractClientSession)this.current;
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    private void log(Level level, String message, Throwable t) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message, t);
        }
    }
}

