/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.HasCanvasListeners;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.rule.graph.GraphRulesManager;
import org.kie.workbench.common.stunner.core.rule.model.ModelRulesManager;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractCanvasHandler<D extends Diagram, C extends AbstractCanvas>
implements CanvasHandler<D, C>,
HasCanvasListeners<CanvasElementListener> {
    private final String uuid;
    private final List<CanvasElementListener> listeners = new LinkedList<CanvasElementListener>();

    public AbstractCanvasHandler() {
        this.uuid = UUID.uuid();
    }

    public abstract DefinitionManager getDefinitionManager();

    public abstract GraphRulesManager getGraphRulesManager();

    public abstract ModelRulesManager getModelRulesManager();

    public abstract Index<?, ?> getGraphIndex();

    public abstract GraphCommandExecutionContext getGraphExecutionContext();

    public abstract void addChild(Element var1, Element var2);

    public abstract void removeChild(Element var1, Element var2);

    public abstract void dock(Element var1, Element var2);

    public abstract void undock(Element var1, Element var2);

    protected abstract CanvasHandler<D, C> doClear();

    protected abstract void doDestroy();

    protected abstract void register(Shape var1, Element<View<?>> var2, boolean var3);

    protected abstract void deregister(Shape var1, Element var2, boolean var3);

    protected abstract void applyElementMutation(Shape var1, Element var2, boolean var3, boolean var4, MutationContext var5);

    protected abstract ShapeFactory<Object, AbstractCanvasHandler, Shape> getShapeFactory(String var1);

    public void register(String shapeSetId, Element<View<?>> candidate) {
        ShapeFactory<Object, AbstractCanvasHandler, Shape> factory = this.getShapeFactory(shapeSetId);
        this.register(factory, candidate, true);
    }

    public void register(ShapeFactory<Object, AbstractCanvasHandler, Shape> factory, Element<View<?>> candidate, boolean fireEvents) {
        assert (factory != null && candidate != null);
        Shape shape = factory.build(((View)candidate.getContent()).getDefinition(), (Object)this);
        if (null == shape.getUUID()) {
            shape.setUUID(candidate.getUUID());
        }
        this.register(shape, candidate, fireEvents);
    }

    public void deregister(Element element) {
        this.deregister(element, true);
    }

    public void deregister(Element element, boolean fireEvents) {
        Shape shape = ((AbstractCanvas)this.getCanvas()).getShape(element.getUUID());
        this.deregister(shape, element, fireEvents);
    }

    public void applyElementMutation(Element element, MutationContext mutationContext) {
        this.applyElementMutation(element, true, true, mutationContext);
    }

    public void updateElementPosition(Element element, MutationContext mutationContext) {
        this.applyElementMutation(element, true, false, mutationContext);
    }

    public void updateElementProperties(Element element, MutationContext mutationContext) {
        this.applyElementMutation(element, false, true, mutationContext);
    }

    protected void applyElementMutation(Element candidate, boolean applyPosition, boolean applyProperties, MutationContext mutationContext) {
        if (null != candidate && !this.isCanvasRoot(candidate)) {
            Shape shape = ((AbstractCanvas)this.getCanvas()).getShape(candidate.getUUID());
            this.applyElementMutation(shape, candidate, applyPosition, applyProperties, mutationContext);
        }
    }

    public HasCanvasListeners<CanvasElementListener> addRegistrationListener(CanvasElementListener instance) {
        this.listeners.add(instance);
        return this;
    }

    public HasCanvasListeners<CanvasElementListener> removeRegistrationListener(CanvasElementListener instance) {
        this.listeners.remove(instance);
        return this;
    }

    public HasCanvasListeners<CanvasElementListener> clearRegistrationListeners() {
        this.listeners.clear();
        return this;
    }

    public void notifyCanvasElementRemoved(Element candidate) {
        for (CanvasElementListener instance : this.listeners) {
            instance.deregister((Object)candidate);
        }
    }

    public void notifyCanvasElementAdded(Element candidate) {
        for (CanvasElementListener instance : this.listeners) {
            instance.register((Object)candidate);
        }
    }

    public void notifyCanvasElementUpdated(Element candidate) {
        for (CanvasElementListener instance : this.listeners) {
            instance.update(candidate);
        }
    }

    protected void notifyCanvasClear() {
        for (CanvasElementListener instance : this.listeners) {
            instance.clear();
        }
    }

    public void clearCanvas() {
        if (null != this.getCanvas()) {
            this.notifyCanvasClear();
            ((AbstractCanvas)this.getCanvas()).clear();
            ((AbstractCanvas)this.getCanvas()).draw();
        }
    }

    public CanvasHandler<D, C> clear() {
        if (null != this.getCanvas()) {
            ((AbstractCanvas)this.getCanvas()).clear();
        }
        this.doClear();
        return this;
    }

    public void destroy() {
        if (null != this.getCanvas()) {
            ((AbstractCanvas)this.getCanvas()).destroy();
        }
        this.doDestroy();
        this.listeners.clear();
    }

    public AbstractCanvas getAbstractCanvas() {
        return (AbstractCanvas)this.getCanvas();
    }

    protected boolean isCanvasRoot(Element parent) {
        return CanvasLayoutUtils.isCanvasRoot(this.getDiagram(), parent);
    }

    protected String getUuid() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCanvasHandler)) {
            return false;
        }
        AbstractCanvasHandler that = (AbstractCanvasHandler)o;
        return this.getUuid().equals(that.getUuid());
    }

    public int hashCode() {
        return this.getUuid() == null ? 0 : ~(~this.getUuid().hashCode());
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getUuid() + "]";
    }
}

