/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.shape.GraphShape;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class BaseCanvasHandler<D extends Diagram, C extends AbstractCanvas>
extends AbstractCanvasHandler<D, C> {
    private static Logger LOGGER = Logger.getLogger(BaseCanvasHandler.class.getName());
    private final DefinitionManager definitionManager;
    private final GraphUtils graphUtils;
    private final ShapeManager shapeManager;
    private C canvas;
    private D diagram;

    public BaseCanvasHandler(DefinitionManager definitionManager, GraphUtils graphUtils, ShapeManager shapeManager) {
        this.definitionManager = definitionManager;
        this.graphUtils = graphUtils;
        this.shapeManager = shapeManager;
    }

    protected abstract void buildGraphIndex(Command var1);

    protected abstract void loadRules(Command var1);

    protected abstract void draw(ParameterizedCommand<CommandResult<?>> var1);

    protected abstract void destroyGraphIndex(Command var1);

    public CanvasHandler<D, C> handle(C canvas) {
        this.canvas = canvas;
        return this;
    }

    public void draw(D diagram, ParameterizedCommand<CommandResult<?>> loadCallback) {
        if (null == this.canvas) {
            throw new IllegalStateException("No handled canvas instance.");
        }
        this.diagram = diagram;
        this.buildGraphIndex(() -> this.loadRules(() -> this.draw(loadCallback)));
    }

    public C getCanvas() {
        return this.canvas;
    }

    public D getDiagram() {
        return this.diagram;
    }

    @Override
    protected ShapeFactory<Object, AbstractCanvasHandler, Shape> getShapeFactory(String shapeSetId) {
        return this.shapeManager.getShapeSet(shapeSetId).getShapeFactory();
    }

    @Override
    protected void register(Shape shape, Element<View<?>> candidate, boolean fireEvents) {
        this.addShape(shape);
        this.getCanvas().draw();
        if (fireEvents) {
            this.notifyCanvasElementAdded(candidate);
            this.afterElementAdded(candidate, shape);
        }
    }

    @Override
    protected void deregister(Shape shape, Element element, boolean fireEvents) {
        if (fireEvents) {
            this.notifyCanvasElementRemoved(element);
            this.beforeElementDeleted(element, shape);
        }
        this.removeShape(shape);
        this.getCanvas().draw();
        if (fireEvents) {
            this.afterElementDeleted(element, shape);
        }
    }

    public void addShape(Shape shape) {
        shape.getShapeView().setZIndex(0);
        this.getCanvas().addShape(shape);
    }

    public void removeShape(Shape shape) {
        this.getCanvas().deleteShape(shape);
    }

    @Override
    protected void applyElementMutation(Shape shape, Element candidate, boolean applyPosition, boolean applyProperties, MutationContext mutationContext) {
        if (shape instanceof GraphShape) {
            GraphShape graphShape = (GraphShape)shape;
            if (applyPosition) {
                graphShape.applyPosition(candidate, mutationContext);
            }
            if (applyProperties) {
                graphShape.applyProperties((Object)candidate, mutationContext);
            }
            this.beforeDraw(candidate, (Shape)graphShape);
            this.beforeElementUpdated(candidate, (Shape)graphShape);
            this.getCanvas().draw();
            this.afterDraw(candidate, (Shape)graphShape);
            this.notifyCanvasElementUpdated(candidate);
            this.afterElementUpdated(candidate, (Shape)graphShape);
        }
    }

    protected void beforeDraw(Element element, Shape shape) {
        if (shape instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)shape;
            lifecycle.beforeDraw();
        }
    }

    protected void afterDraw(Element element, Shape shape) {
        if (shape instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)shape;
            lifecycle.afterDraw();
        }
    }

    @Override
    public void addChild(Element parent, Element child) {
        Shape childShape = this.getCanvas().getShape(child.getUUID());
        if (!this.isCanvasRoot(parent)) {
            Shape parentShape = this.getCanvas().getShape(parent.getUUID());
            this.handleParentChildZIndex(parent, child, parentShape, childShape, true);
            this.getCanvas().addChildShape(parentShape, childShape);
        } else {
            this.getCanvas().getLayer().addShape((Object)childShape.getShapeView());
        }
    }

    @Override
    public void removeChild(Element parent, Element child) {
        String parentUUID = parent.getUUID();
        String childUUID = child.getUUID();
        Shape childShape = this.getCanvas().getShape(childUUID);
        if (!this.isCanvasRoot(parentUUID)) {
            Shape parentShape = this.getCanvas().getShape(parentUUID);
            this.handleParentChildZIndex(null, null, parentShape, childShape, false);
            this.getCanvas().deleteChildShape(parentShape, childShape);
        } else {
            this.getCanvas().getLayer().removeShape((Object)childShape.getShapeView());
        }
    }

    protected boolean isCanvasRoot(String pUUID) {
        return CanvasLayoutUtils.isCanvasRoot(this.getDiagram(), pUUID);
    }

    @Override
    public void dock(Element parent, Element child) {
        if (!this.isCanvasRoot(parent)) {
            Shape parentShape = this.getCanvas().getShape(parent.getUUID());
            Shape childShape = this.getCanvas().getShape(child.getUUID());
            this.handleParentChildZIndex(parent, child, parentShape, childShape, true);
            this.getCanvas().dock(parentShape, childShape);
        }
    }

    @Override
    public void undock(Element parent, Element child) {
        String parentUUID = parent.getUUID();
        String childUUID = child.getUUID();
        if (!this.isCanvasRoot(parentUUID)) {
            Shape parentShape = this.getCanvas().getShape(parentUUID);
            Shape childShape = this.getCanvas().getShape(childUUID);
            this.handleParentChildZIndex(null, null, parentShape, childShape, false);
            this.getCanvas().undock(parentShape, childShape);
        }
    }

    protected void afterElementAdded(Element element, Shape shape) {
    }

    protected void beforeElementDeleted(Element element, Shape shape) {
    }

    protected void afterElementDeleted(Element element, Shape shape) {
    }

    protected void beforeElementUpdated(Element element, Shape shape) {
    }

    protected void afterElementUpdated(Element element, Shape shape) {
    }

    protected void handleParentChildZIndex(Element parent, Element child, Shape parentShape, Shape childShape, boolean add) {
        if (add) {
            this.handleZIndex(childShape, parentShape.getShapeView().getZIndex() + 1);
            this.handleZIndex(child, parentShape.getShapeView().getZIndex() + 1);
        } else {
            this.handleZIndex(childShape, 0);
            Element element = this.getGraphIndex().get(childShape.getUUID());
            if (null != element) {
                this.handleZIndex(element, 0);
            }
        }
    }

    protected void handleZIndex(Element child, int zindex) {
        Node childNode;
        List outEdges;
        if (child instanceof Node && null != (outEdges = (childNode = (Node)child).getOutEdges()) && !outEdges.isEmpty()) {
            LinkedHashSet<String> suuids = new LinkedHashSet<String>();
            for (Edge edge : outEdges) {
                if (!(edge.getContent() instanceof View)) continue;
                suuids.add(edge.getUUID());
            }
            this.handleZIndex(suuids, zindex);
        }
    }

    protected void handleZIndex(Set<String> shapeUUIDs, int zindex) {
        for (String suuid : shapeUUIDs) {
            Shape edgeShape = this.getCanvas().getShape(suuid);
            this.handleZIndex(edgeShape, zindex);
        }
    }

    protected void handleZIndex(Shape shape, int zindex) {
        if (null != shape) {
            shape.getShapeView().setZIndex(zindex);
        }
    }

    @Override
    public CanvasHandler<D, C> doClear() {
        this.destroyGraphIndex(() -> {
            this.diagram = null;
        });
        return this;
    }

    @Override
    public void doDestroy() {
        this.destroyGraphIndex(() -> {
            this.canvas = null;
            this.diagram = null;
        });
    }

    protected void showError(ClientRuntimeError error) {
        String message = error.getThrowable() != null ? error.getThrowable().getMessage() : error.getMessage();
        this.log(Level.SEVERE, message);
    }

    @Override
    public DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    public GraphUtils getGraphUtils() {
        return this.graphUtils;
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    protected String getDefinitionId(Object definition) {
        return this.definitionManager.adapters().forDefinition().getId(definition);
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

