/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasNameEditionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasValidationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.EdgeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.Observer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ConnectionAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.containment.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.docking.DockingAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.drag.DragControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.palette.CanvasPaletteControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.resize.ResizeControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;

@ApplicationScoped
public class CanvasFactoryImpl
implements CanvasFactory<AbstractCanvas, AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(CanvasFactoryImpl.class.getName());
    private final ManagedInstance<ResizeControl> resizeControls;
    private final ManagedInstance<CanvasValidationControl> validationControls;
    private final ManagedInstance<CanvasPaletteControl> paletteControls;
    private final ManagedInstance<ConnectionAcceptorControl> connectionAcceptorControls;
    private final ManagedInstance<ContainmentAcceptorControl> containmentAcceptorControls;
    private final ManagedInstance<DockingAcceptorControl> dockingAcceptorControls;
    private final ManagedInstance<CanvasNameEditionControl> nameEditionControls;
    private final ManagedInstance<SelectionControl> selectionControls;
    private final ManagedInstance<DragControl> dragControls;
    private final ManagedInstance<ToolboxControl> toolboxControls;
    private final ManagedInstance<ElementBuilderControl> elementBuilderControls;
    private final ManagedInstance<NodeBuilderControl> nodeBuilderControls;
    private final ManagedInstance<EdgeBuilderControl> edgeBuilderControls;
    private final ManagedInstance<ZoomControl> zoomControls;
    private final ManagedInstance<PanControl> panControls;
    private final ManagedInstance<AbstractCanvas> canvasInstances;
    private final ManagedInstance<AbstractCanvasHandler> canvasHandlerInstances;
    private final Map<Class<? extends CanvasControl>, ManagedInstance> controls = new HashMap<Class<? extends CanvasControl>, ManagedInstance>(15);

    protected CanvasFactoryImpl() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Inject
    public CanvasFactoryImpl(ManagedInstance<ResizeControl> resizeControls, ManagedInstance<CanvasValidationControl> validationControls, ManagedInstance<CanvasPaletteControl> paletteControls, ManagedInstance<ConnectionAcceptorControl> connectionAcceptorControls, ManagedInstance<ContainmentAcceptorControl> containmentAcceptorControls, ManagedInstance<DockingAcceptorControl> dockingAcceptorControls, ManagedInstance<CanvasNameEditionControl> nameEditionControls, ManagedInstance<SelectionControl> selectionControls, ManagedInstance<DragControl> dragControls, ManagedInstance<ToolboxControl> toolboxControls, @Observer ManagedInstance<ElementBuilderControl> elementBuilderControls, ManagedInstance<NodeBuilderControl> nodeBuilderControls, ManagedInstance<EdgeBuilderControl> edgeBuilderControls, ManagedInstance<ZoomControl> zoomControls, ManagedInstance<PanControl> panControls, @Default ManagedInstance<AbstractCanvas> canvasInstances, @Default ManagedInstance<AbstractCanvasHandler> canvasHandlerInstances) {
        this.resizeControls = resizeControls;
        this.validationControls = validationControls;
        this.paletteControls = paletteControls;
        this.connectionAcceptorControls = connectionAcceptorControls;
        this.containmentAcceptorControls = containmentAcceptorControls;
        this.dockingAcceptorControls = dockingAcceptorControls;
        this.nameEditionControls = nameEditionControls;
        this.selectionControls = selectionControls;
        this.dragControls = dragControls;
        this.toolboxControls = toolboxControls;
        this.elementBuilderControls = elementBuilderControls;
        this.nodeBuilderControls = nodeBuilderControls;
        this.edgeBuilderControls = edgeBuilderControls;
        this.zoomControls = zoomControls;
        this.panControls = panControls;
        this.canvasInstances = canvasInstances;
        this.canvasHandlerInstances = canvasHandlerInstances;
    }

    @PostConstruct
    public void init() {
        this.controls.put(ResizeControl.class, this.resizeControls);
        this.controls.put(CanvasValidationControl.class, this.validationControls);
        this.controls.put(CanvasPaletteControl.class, this.paletteControls);
        this.controls.put(ConnectionAcceptorControl.class, this.connectionAcceptorControls);
        this.controls.put(ContainmentAcceptorControl.class, this.containmentAcceptorControls);
        this.controls.put(DockingAcceptorControl.class, this.dockingAcceptorControls);
        this.controls.put(CanvasNameEditionControl.class, this.nameEditionControls);
        this.controls.put(SelectionControl.class, this.selectionControls);
        this.controls.put(DragControl.class, this.dragControls);
        this.controls.put(ToolboxControl.class, this.toolboxControls);
        this.controls.put(ElementBuilderControl.class, this.elementBuilderControls);
        this.controls.put(NodeBuilderControl.class, this.nodeBuilderControls);
        this.controls.put(EdgeBuilderControl.class, this.edgeBuilderControls);
        this.controls.put(ZoomControl.class, this.zoomControls);
        this.controls.put(PanControl.class, this.panControls);
    }

    public AbstractCanvas newCanvas() {
        return (AbstractCanvas)this.canvasInstances.get();
    }

    public AbstractCanvasHandler newCanvasHandler() {
        return (AbstractCanvasHandler)this.canvasHandlerInstances.get();
    }

    public <A extends CanvasControl> A newControl(Class<A> type) {
        if (this.controls.containsKey(type)) {
            ManagedInstance mi = this.controls.get(type);
            return (A)((CanvasControl)mi.get());
        }
        LOGGER.log(Level.WARNING, "Canvas Control for type [" + type.getName() + "] is not supported by this canvas factory [" + this.getClass().getName() + "]");
        return null;
    }
}

