/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.AbstractTreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

public abstract class AbstractCanvasNodeRegistrationCommand
extends AbstractCanvasCommand {
    private static Logger LOGGER = Logger.getLogger(AbstractCanvasNodeRegistrationCommand.class.getName());
    private final TreeWalkTraverseProcessor treeWalkTraverseProcessor;
    private final Node node;
    private Command<AbstractCanvasHandler, CanvasViolation> command;

    protected AbstractCanvasNodeRegistrationCommand(TreeWalkTraverseProcessor treeWalkTraverseProcessor, Node node) {
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
        this.node = node;
        this.command = null;
    }

    protected abstract String getShapeSetId(AbstractCanvasHandler var1);

    protected abstract boolean registerCandidate(AbstractCanvasHandler var1);

    public CommandResult<CanvasViolation> execute(final AbstractCanvasHandler context) {
        final Diagram diagram = context.getDiagram();
        final String shapeSetId = null == this.getShapeSetId(context) ? context.getDiagram().getMetadata().getShapeSetId() : this.getShapeSetId(context);
        this.treeWalkTraverseProcessor.useEdgeVisitorPolicy(TreeWalkTraverseProcessor.EdgeVisitorPolicy.VISIT_EDGE_AFTER_TARGET_NODE).traverse(diagram.getGraph(), this.node, (TreeTraverseCallback)new AbstractTreeTraverseCallback<Graph, Node, Edge>(){
            private CompositeCommandImpl.CompositeCommandBuilder<AbstractCanvasHandler, CanvasViolation> commandBuilder;

            public void startGraphTraversal(Graph graph) {
                AbstractCanvasNodeRegistrationCommand.this.command = null;
                this.commandBuilder = new CompositeCommandImpl.CompositeCommandBuilder().forward();
            }

            public boolean startNodeTraversal(Node node) {
                if (CanvasLayoutUtils.isCanvasRoot(diagram, (Element)node)) {
                    return true;
                }
                if (null != AbstractCanvasNodeRegistrationCommand.this.node && AbstractCanvasNodeRegistrationCommand.this.node.equals(node)) {
                    return AbstractCanvasNodeRegistrationCommand.this.registerCandidate(context);
                }
                if (node.getContent() instanceof View && this.isChild(node)) {
                    this.commandBuilder.addCommand((Command)new AddCanvasNodeCommand(node, shapeSetId));
                    return true;
                }
                return false;
            }

            public boolean startEdgeTraversal(Edge edge) {
                Object content = edge.getContent();
                if (content instanceof View) {
                    this.commandBuilder.addCommand((Command)new AddCanvasConnectorCommand(edge, shapeSetId));
                    return true;
                }
                if (content instanceof Child) {
                    Node child = edge.getTargetNode();
                    Node parent = edge.getSourceNode();
                    Object childContent = child.getContent();
                    if (childContent instanceof View) {
                        this.commandBuilder.addCommand((Command)new SetCanvasChildNodeCommand(parent, child));
                    }
                    return true;
                }
                if (content instanceof Dock) {
                    Node docked = edge.getTargetNode();
                    Node parent = edge.getSourceNode();
                    Object dockedContent = docked.getContent();
                    if (dockedContent instanceof View) {
                        this.commandBuilder.addCommand((Command)new CanvasDockNodeCommand(parent, docked));
                    }
                    return true;
                }
                return false;
            }

            public void endGraphTraversal() {
                super.endGraphTraversal();
                if (this.commandBuilder.size() > 0) {
                    AbstractCanvasNodeRegistrationCommand.this.command = (Command)this.commandBuilder.build();
                }
            }

            private boolean isChild(Node<?, Edge> candidate) {
                return null == AbstractCanvasNodeRegistrationCommand.this.getCandidate() || candidate.getInEdges().stream().filter(edge -> {
                    if (edge.getContent() instanceof Child) {
                        Node parent = edge.getSourceNode();
                        return null != parent && (parent.equals(AbstractCanvasNodeRegistrationCommand.this.getCandidate()) || this.isChild(parent));
                    }
                    return false;
                }).findFirst().isPresent();
            }
        });
        if (null != this.command) {
            return this.command.execute((Object)context);
        }
        return this.buildResult();
    }

    public Node getCandidate() {
        return this.node;
    }
}

