/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasUndockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasConnectionCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.SafeDeleteNodeProcessor;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public abstract class AbstractNodeDeregistrationCommand
extends AbstractCanvasGraphCommand {
    private final Node candidate;
    private transient CompositeCommand<AbstractCanvasHandler, CanvasViolation> command;
    private final SafeDeleteNodeProcessor.Callback safeDeleteCallback = new SafeDeleteNodeProcessor.Callback(){

        public void deleteChildNode(Node<Definition<?>, Edge> node) {
        }

        public void deleteInViewEdge(Edge<View<?>, Node> edge) {
            AbstractNodeDeregistrationCommand.this.getCommand().addCommand((Command)new SetCanvasConnectionCommand(edge));
        }

        public void deleteInChildEdge(Edge<Child, Node> edge) {
            Node parent = edge.getSourceNode();
            Node candidate = edge.getTargetNode();
            AbstractNodeDeregistrationCommand.this.getCommand().addCommand((Command)new RemoveCanvasChildCommand(parent, candidate));
        }

        public void deleteInDockEdge(Edge<Dock, Node> edge) {
            Node parent = edge.getSourceNode();
            Node candidate = edge.getTargetNode();
            AbstractNodeDeregistrationCommand.this.getCommand().addCommand((Command)new CanvasUndockNodeCommand(parent, candidate));
        }

        public void deleteOutViewEdge(Edge<? extends View<?>, Node> edge) {
            AbstractNodeDeregistrationCommand.this.getCommand().addCommand((Command)new SetCanvasConnectionCommand(edge));
        }

        public void deleteNode(Node<Definition<?>, Edge> node) {
            if (node.equals((Object)AbstractNodeDeregistrationCommand.this.getCandidate())) {
                AbstractNodeDeregistrationCommand.this.getCommand().addCommand(AbstractNodeDeregistrationCommand.this.getDeregistrationCommand());
            } else {
                AbstractNodeDeregistrationCommand.this.getCommand().addCommand((Command)new DeleteCanvasNodeCommand(node));
            }
        }
    };

    public AbstractNodeDeregistrationCommand(Node candidate) {
        this.candidate = candidate;
        this.command = new CompositeCommandImpl.CompositeCommandBuilder().reverse().build();
    }

    protected abstract Command<AbstractCanvasHandler, CanvasViolation> getDeregistrationCommand();

    @Override
    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new SafeDeleteNodeCommand(this.candidate, this.getSafeDeleteCallback(context));
    }

    protected SafeDeleteNodeProcessor.Callback getSafeDeleteCallback(AbstractCanvasHandler context) {
        return this.safeDeleteCallback;
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return this.command;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    protected CompositeCommand<AbstractCanvasHandler, CanvasViolation> getCommand() {
        return this.command;
    }
}

