/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasNodeRegistrationCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessorImpl;

public final class AddCanvasChildNodeCommand
extends AbstractCanvasNodeRegistrationCommand {
    private final Node parent;
    private final String shapeSetId;

    public AddCanvasChildNodeCommand(TreeWalkTraverseProcessor treeWalkTraverseProcessor, Node parent, Node candidate, String shapeSetId) {
        super(treeWalkTraverseProcessor, candidate);
        this.parent = parent;
        this.shapeSetId = shapeSetId;
    }

    AddCanvasChildNodeCommand(Node parent, Node candidate, String shapeSetId) {
        super((TreeWalkTraverseProcessor)new TreeWalkTraverseProcessorImpl(), candidate);
        this.parent = parent;
        this.shapeSetId = shapeSetId;
    }

    @Override
    protected String getShapeSetId(AbstractCanvasHandler context) {
        return this.shapeSetId;
    }

    @Override
    protected boolean registerCandidate(AbstractCanvasHandler context) {
        context.register(this.shapeSetId, (Element<View<?>>)this.getCandidate());
        context.addChild((Element)this.parent, (Element)this.getCandidate());
        context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        context.applyElementMutation((Element)this.getCandidate(), MutationContext.STATIC);
        return false;
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new CompositeCommandImpl.CompositeCommandBuilder().addCommand((Command)new RemoveCanvasChildCommand(this.parent, this.getCandidate())).addCommand((Command)new DeleteCanvasNodeCommand(this.getCandidate(), this.parent)).build().execute((Object)context);
    }

    public Node getParent() {
        return this.parent;
    }

    public String getShapeSetId() {
        return this.shapeSetId;
    }
}

