/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddDockedNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.ClearCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DrawCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.MorphNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

@ApplicationScoped
public class CanvasCommandFactory {
    private final TreeWalkTraverseProcessor treeWalkTraverseProcessor;

    protected CanvasCommandFactory() {
        this.treeWalkTraverseProcessor = null;
    }

    @Inject
    public CanvasCommandFactory(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
    }

    public AddNodeCommand addNode(Node candidate, String shapeSetId) {
        return new AddNodeCommand(candidate, shapeSetId);
    }

    public AddChildNodeCommand addChildNode(Node parent, Node candidate, String shapeSetId) {
        return new AddChildNodeCommand(parent, candidate, shapeSetId);
    }

    public AddDockedNodeCommand addDockedNode(Node parent, Node candidate, String shapeSetId) {
        return new AddDockedNodeCommand(parent, candidate, shapeSetId);
    }

    public AddConnectorCommand addConnector(Node sourceNode, Edge candidate, int magnetIndex, String shapeSetId) {
        return new AddConnectorCommand(sourceNode, candidate, magnetIndex, shapeSetId);
    }

    public SetChildNodeCommand setChildNode(Node parent, Node candidate) {
        return new SetChildNodeCommand(parent, candidate);
    }

    public DockNodeCommand dockNode(Node parent, Node candidate) {
        return new DockNodeCommand(parent, candidate);
    }

    public DeleteNodeCommand deleteNode(Node candidate) {
        return new DeleteNodeCommand(candidate);
    }

    public RemoveChildCommand removeChild(Node parent, Node candidate) {
        return new RemoveChildCommand(parent, candidate);
    }

    public UnDockNodeCommand unDockNode(Node parent, Node candidate) {
        return new UnDockNodeCommand(parent, candidate);
    }

    public DeleteConnectorCommand deleteConnector(Edge candidate) {
        return new DeleteConnectorCommand(candidate);
    }

    public DrawCanvasCommand draw() {
        return new DrawCanvasCommand(this.treeWalkTraverseProcessor);
    }

    public MorphNodeCommand morphNode(Node<? extends Definition<?>, Edge> candidate, MorphDefinition morphDefinition, String morphTarget, String shapeSetId) {
        return new MorphNodeCommand(candidate, morphDefinition, morphTarget, shapeSetId);
    }

    public SetConnectionSourceNodeCommand setSourceNode(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> edge, int magnetIndex) {
        return new SetConnectionSourceNodeCommand(node, edge, magnetIndex);
    }

    public SetConnectionTargetNodeCommand setTargetNode(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> edge, int magnetIndex) {
        return new SetConnectionTargetNodeCommand(node, edge, magnetIndex);
    }

    public UpdateElementPositionCommand updatePosition(Node<View<?>, Edge> element, Double x, Double y) {
        return new UpdateElementPositionCommand(element, x, y);
    }

    public UpdateElementPropertyCommand updatePropertyValue(Element element, String propertyId, Object value) {
        return new UpdateElementPropertyCommand(element, propertyId, value);
    }

    public ClearCommand clearCanvas() {
        return new ClearCommand();
    }
}

