/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasNodeRegistrationCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

public final class DrawCanvasCommand
extends AbstractCanvasCommand {
    private static Logger LOGGER = Logger.getLogger(DrawCanvasCommand.class.getName());
    private final TreeWalkTraverseProcessor treeWalkTraverseProcessor;

    public DrawCanvasCommand(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        Diagram diagram = context.getDiagram();
        String shapeSetId = this.getShapeSetId(context);
        String rootUUID = diagram.getMetadata().getCanvasRootUUID();
        AbstractCanvasNodeRegistrationCommand command = null;
        if (null != rootUUID) {
            Node root = context.getGraphIndex().getNode(rootUUID);
            command = new AddCanvasNodeCommand(this.treeWalkTraverseProcessor, root, shapeSetId);
        } else {
            command = new CanvasNodesRegistrationCommand();
        }
        return command.execute(context);
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        throw new UnsupportedOperationException("Undo operation for [" + this.getClass().getName() + "[ is not supported..");
    }

    private String getShapeSetId(AbstractCanvasHandler context) {
        return context.getDiagram().getMetadata().getShapeSetId();
    }

    private final class CanvasNodesRegistrationCommand
    extends AbstractCanvasNodeRegistrationCommand {
        private CanvasNodesRegistrationCommand() {
            super(DrawCanvasCommand.this.treeWalkTraverseProcessor, null);
        }

        @Override
        protected String getShapeSetId(AbstractCanvasHandler context) {
            return DrawCanvasCommand.this.getShapeSetId(context);
        }

        @Override
        protected boolean registerCandidate(AbstractCanvasHandler context) {
            context.register(this.getShapeSetId(context), (Element<View<?>>)this.getCandidate());
            context.applyElementMutation((Element)this.getCandidate(), MutationContext.STATIC);
            return true;
        }

        public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
            return DrawCanvasCommand.this.undo(context);
        }
    }
}

