/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public final class SetCanvasConnectionCommand
extends AbstractCanvasCommand {
    private static Logger LOGGER = Logger.getLogger(SetCanvasConnectionCommand.class.getName());
    private final Edge<? extends View<?>, Node> edge;

    public SetCanvasConnectionCommand(Edge<? extends View<?>, Node> edge) {
        this.edge = edge;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        Node source = this.edge.getSourceNode();
        Node target = this.edge.getTargetNode();
        ShapeUtils.applyConnections(this.edge, context, MutationContext.STATIC);
        if (null != source) {
            context.notifyCanvasElementUpdated((Element)source);
            SetCanvasConnectionCommand.highlightInvalidConnection(context, this.edge, source);
        }
        if (null != target) {
            context.notifyCanvasElementUpdated((Element)target);
            SetCanvasConnectionCommand.highlightInvalidConnection(context, this.edge, target);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new SetCanvasConnectionCommand(this.edge).execute(context);
    }

    public static void highlightInvalidConnection(AbstractCanvasHandler context, Edge<? extends View<?>, Node> edge, Node<? extends View<?>, Edge> node) {
        String uuid = edge.getUUID();
        Shape shape = context.getCanvas().getShape(uuid);
        if (null != shape) {
            ShapeState state = null != node ? ShapeState.NONE : ShapeState.INVALID;
            LOGGER.log(Level.FINE, "Highlight connector for UUID [" + uuid + "] with state [" + state + "]");
            shape.applyState(state);
        } else {
            LOGGER.log(Level.WARNING, "Cannot highlight connector as it is not found for UUID [" + uuid + "]");
        }
    }

    public Edge<? extends View<?>, Node> getEdge() {
        return this.edge;
    }
}

