/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistationControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractCanvasHandlerRegistrationControl<H extends AbstractCanvasHandler>
extends AbstractCanvasHandlerControl<H>
implements CanvasRegistationControl<H, Element> {
    private static Logger LOGGER = Logger.getLogger(AbstractCanvasHandlerRegistrationControl.class.getName());
    private final Map<String, ViewHandler<?>> handlers = new HashMap();

    public void update(Element element) {
    }

    protected void registerHandler(String uuid, ViewHandler<?> handler) {
        this.handlers.put(uuid, handler);
    }

    @Override
    protected void doDisable() {
        this.deregisterAll();
    }

    public void deregisterAll() {
        new HashSet<String>(this.handlers.keySet()).stream().forEach(this::deregister);
        this.handlers.clear();
    }

    public void deregister(Element element) {
        this.deregister(element.getUUID());
    }

    public boolean isRegistered(Element element) {
        return this.handlers.containsKey(element.getUUID());
    }

    protected void deregister(String uuid) {
        Shape shape = this.canvasHandler.getCanvas().getShape(uuid);
        ViewHandler<?> handler = this.handlers.get(uuid);
        this.doDeregisterHandler(shape, handler);
    }

    protected boolean checkNotRegistered(Element element) {
        if (this.isRegistered(element)) {
            LOGGER.log(Level.WARNING, "Trying to register element [" + element.getUUID() + "] again into the control for type [" + this.getClass().getName() + "]");
            return false;
        }
        return true;
    }

    protected boolean checkEventContext(AbstractCanvasHandlerEvent canvasHandlerEvent) {
        CanvasHandler _canvasHandler = canvasHandlerEvent.getCanvasHandler();
        return this.canvasHandler != null && this.canvasHandler.equals(_canvasHandler);
    }

    private void doDeregisterHandler(Shape shape, ViewHandler<?> handler) {
        if (null != shape && null != handler) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            hasEventHandlers.removeHandler(handler);
            this.handlers.remove(shape.getUUID());
        }
    }
}

