/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls;

import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistationControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Element;

public class CanvasControlRegistrationHandler<C extends AbstractCanvas, H extends AbstractCanvasHandler>
implements RequiresCommandManager<H> {
    private final List<CanvasControl<C>> canvasControls = new LinkedList<CanvasControl<C>>();
    private final List<CanvasControl<H>> canvasHandlerControls = new LinkedList<CanvasControl<H>>();
    private final C canvas;
    private final H handler;
    private CanvasShapeListener shapeListener;
    private CanvasElementListener elementListener;
    private RequiresCommandManager.CommandManagerProvider<H> commandManagerProvider;

    public CanvasControlRegistrationHandler(C canvas, H handler) {
        this.canvas = canvas;
        this.handler = handler;
    }

    public void registerCanvasControl(CanvasControl<C> control) {
        this.canvasControls.add(control);
    }

    public void registerCanvasHandlerControl(CanvasControl<H> control) {
        this.canvasHandlerControls.add(control);
    }

    public void enable() {
        this.initializeListeners();
        this.enableControls();
    }

    public void disable() {
        this.removeListeners();
        this.disableControls();
    }

    public void enableCanvasControl(CanvasControl<C> control) {
        if (null != control) {
            control.enable(this.getCanvas());
        }
    }

    public void enableCanvasHandlerControl(CanvasControl<H> control) {
        if (null != control) {
            control.enable(this.getCanvasHandler());
            if (null != this.commandManagerProvider && control instanceof RequiresCommandManager) {
                ((RequiresCommandManager)control).setCommandManagerProvider(this.commandManagerProvider);
            }
        }
    }

    public void clear() {
        this.disable();
        this.canvasControls.clear();
        this.canvasHandlerControls.clear();
    }

    public void destroy() {
        this.clear();
        ((AbstractCanvas)this.canvas).clearRegistrationListeners();
        ((AbstractCanvasHandler)this.handler).clearRegistrationListeners();
        this.shapeListener = null;
        this.elementListener = null;
        this.commandManagerProvider = null;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<H> provider) {
        this.commandManagerProvider = provider;
    }

    private void enableControls() {
        this.canvasControls.forEach(this::enableCanvasControl);
        this.canvasHandlerControls.forEach(this::enableCanvasHandlerControl);
    }

    private void disableControls() {
        this.canvasControls.forEach(CanvasControl::disable);
        this.canvasHandlerControls.forEach(CanvasControl::disable);
    }

    private void fireRegistrationListeners(CanvasControl<H> control, Element element, boolean add) {
        if (null != control && null != element && control instanceof CanvasRegistationControl) {
            CanvasRegistationControl registationControl = (CanvasRegistationControl)control;
            if (add) {
                registationControl.register((Object)element);
            } else {
                registationControl.deregister((Object)element);
            }
        }
    }

    private void fireRegistrationListeners(CanvasControl<C> control, Shape shape, boolean add) {
        if (null != control && null != shape && control instanceof CanvasRegistationControl) {
            CanvasRegistationControl registationControl = (CanvasRegistationControl)control;
            if (add) {
                registationControl.register((Object)shape);
            } else {
                registationControl.deregister((Object)shape);
            }
        }
    }

    private void fireRegistrationUpdateListeners(CanvasControl<H> control, Element element) {
        if (null != control && null != element && control instanceof AbstractCanvasHandlerRegistrationControl) {
            AbstractCanvasHandlerRegistrationControl registationControl = (AbstractCanvasHandlerRegistrationControl)control;
            registationControl.update(element);
        }
    }

    private void fireRegistrationClearListeners(CanvasControl<H> control) {
        if (null != control && control instanceof AbstractCanvasHandlerRegistrationControl) {
            AbstractCanvasHandlerRegistrationControl registationControl = (AbstractCanvasHandlerRegistrationControl)control;
            registationControl.deregisterAll();
        }
    }

    private C getCanvas() {
        return this.canvas;
    }

    private H getCanvasHandler() {
        return this.handler;
    }

    private void initializeListeners() {
        C canvas = this.getCanvas();
        this.shapeListener = new CanvasShapeListener(){

            public void register(Shape item) {
                CanvasControlRegistrationHandler.this.onRegisterShape(item);
            }

            public void deregister(Shape item) {
                CanvasControlRegistrationHandler.this.onDeregisterShape(item);
            }

            public void clear() {
                CanvasControlRegistrationHandler.this.onClear();
            }
        };
        ((AbstractCanvas)canvas).addRegistrationListener(this.shapeListener);
        this.elementListener = new CanvasElementListener(){

            public void update(Element item) {
                CanvasControlRegistrationHandler.this.onElementRegistration(item, false, true);
            }

            public void register(Element item) {
                CanvasControlRegistrationHandler.this.onRegisterElement(item);
            }

            public void deregister(Element item) {
                CanvasControlRegistrationHandler.this.onDeregisterElement(item);
            }

            public void clear() {
                CanvasControlRegistrationHandler.this.onClear();
            }
        };
        ((AbstractCanvasHandler)this.getCanvasHandler()).addRegistrationListener(this.elementListener);
    }

    private void removeListeners() {
        if (null != this.shapeListener) {
            ((AbstractCanvas)this.getCanvas()).removeRegistrationListener(this.shapeListener);
        }
        if (null != this.elementListener) {
            ((AbstractCanvasHandler)this.getCanvasHandler()).removeRegistrationListener(this.elementListener);
        }
    }

    private void onRegisterShape(Shape shape) {
        this.onShapeRegistration(shape, true);
    }

    private void onDeregisterShape(Shape shape) {
        this.onShapeRegistration(shape, false);
    }

    private void onRegisterElement(Element element) {
        this.onElementRegistration(element, true, false);
    }

    private void onDeregisterElement(Element element) {
        this.onElementRegistration(element, false, false);
    }

    private void onElementRegistration(Element element, boolean add, boolean update) {
        if (update) {
            this.canvasHandlerControls.forEach(c -> this.fireRegistrationUpdateListeners((CanvasControl<H>)c, element));
        } else {
            this.canvasHandlerControls.forEach(c -> this.fireRegistrationListeners((CanvasControl<H>)c, element, add));
        }
    }

    private void onShapeRegistration(Shape shape, boolean add) {
        this.canvasControls.forEach(c -> this.fireRegistrationListeners((CanvasControl<C>)c, shape, add));
    }

    private void onClear() {
        this.canvasHandlerControls.forEach(this::fireRegistrationClearListeners);
    }
}

