/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.EdgeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.EdgeBuildRequest;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.util.EdgeMagnetsHelper;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@Dependent
public class EdgeBuilderControlImpl
extends AbstractCanvasHandlerControl<AbstractCanvasHandler>
implements EdgeBuilderControl<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(EdgeBuilderControlImpl.class.getName());
    private final ClientDefinitionManager clientDefinitionManager;
    private final ShapeManager shapeManager;
    private final CanvasCommandFactory commandFactory;
    private final EdgeMagnetsHelper magnetsHelper;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected EdgeBuilderControlImpl() {
        this(null, null, null, null);
    }

    @Inject
    public EdgeBuilderControlImpl(ClientDefinitionManager clientDefinitionManager, ShapeManager shapeManager, CanvasCommandFactory commandFactory, EdgeMagnetsHelper magnetsHelper) {
        this.clientDefinitionManager = clientDefinitionManager;
        this.shapeManager = shapeManager;
        this.commandFactory = commandFactory;
        this.magnetsHelper = magnetsHelper;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public boolean allows(EdgeBuildRequest request) {
        double x = request.getX();
        double y = request.getY();
        Edge edge = request.getEdge();
        AbstractCanvasHandler wch = this.canvasHandler;
        Node inNode = request.getInNode();
        Node outNode = request.getOutNode();
        boolean allowsSourceConn = true;
        if (null != inNode) {
            CommandResult cr1 = this.getCommandManager().allow((Object)wch, (Command)this.commandFactory.setSourceNode(inNode, edge, 0));
            allowsSourceConn = this.isAllowed((CommandResult<CanvasViolation>)cr1);
        }
        boolean allowsTargetConn = true;
        if (null != outNode) {
            CommandResult cr2 = this.getCommandManager().allow((Object)wch, (Command)this.commandFactory.setTargetNode(outNode, edge, 0));
            allowsTargetConn = this.isAllowed((CommandResult<CanvasViolation>)cr2);
        }
        return allowsSourceConn & allowsTargetConn;
    }

    public void build(EdgeBuildRequest request, BuilderControl.BuildCallback buildCallback) {
        CommandResult results;
        double x = request.getX();
        double y = request.getY();
        Edge edge = request.getEdge();
        AbstractCanvasHandler wch = this.canvasHandler;
        Node inNode = request.getInNode();
        Node outNode = request.getOutNode();
        Canvas canvas = this.canvasHandler.getCanvas();
        if (null == inNode) {
            throw new RuntimeException(" An edge must be into the outgoing edges list from a node.");
        }
        Shape sourceShape = canvas.getShape(inNode.getUUID());
        Shape targetShape = outNode != null ? canvas.getShape(outNode.getUUID()) : null;
        int[] magnetIndexes = new int[]{0, 0};
        if (targetShape != null) {
            magnetIndexes = this.magnetsHelper.getDefaultMagnetsIndex(sourceShape.getShapeView(), targetShape.getShapeView());
        }
        Object edgeDef = ((View)edge.getContent()).getDefinition();
        String ssid = this.canvasHandler.getDiagram().getMetadata().getShapeSetId();
        CompositeCommandImpl.CompositeCommandBuilder commandBuilder = new CompositeCommandImpl.CompositeCommandBuilder().addCommand((Command)this.commandFactory.addConnector(inNode, edge, magnetIndexes[0], ssid));
        if (null != outNode) {
            commandBuilder.addCommand((Command)this.commandFactory.setTargetNode(outNode, edge, magnetIndexes[1]));
        }
        if (CommandUtils.isError((CommandResult)(results = this.getCommandManager().execute((Object)wch, (Command)commandBuilder.build())))) {
            LOGGER.log(Level.SEVERE, results.toString());
        }
        this.canvasHandler.applyElementMutation((Element)edge, MutationContext.STATIC);
        buildCallback.onSuccess(edge.getUUID());
    }

    @Override
    protected void doDisable() {
        this.commandManagerProvider = null;
    }

    private boolean isAllowed(CommandResult<CanvasViolation> result) {
        return !CommandResult.Type.ERROR.equals((Object)result.getType());
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }
}

