/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.drag;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasGrid;
import org.kie.workbench.common.stunner.core.client.canvas.Point2D;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.drag.DragControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Dependent
public class DragControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements DragControl<AbstractCanvasHandler, Element> {
    private static Logger LOGGER = Logger.getLogger(DragControlImpl.class.getName());
    private static final int delta = 10;
    private final CanvasCommandFactory canvasCommandFactory;
    private CanvasGrid dragGrid;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected DragControlImpl() {
        this(null);
    }

    @Inject
    public DragControlImpl(CanvasCommandFactory canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public void register(final Element element) {
        AbstractCanvas canvas;
        Shape shape;
        if (this.checkNotRegistered(element) && (shape = (canvas = this.canvasHandler.getAbstractCanvas()).getShape(element.getUUID())).getShapeView() instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            DragHandler handler = new DragHandler(){
                private final double[] shapeSize = new double[]{0.0, 0.0};
                private CanvasGrid grid = null;

                public void start(DragEvent event) {
                    double[] size = GraphUtils.getNodeSize((View)((View)element.getContent()));
                    this.shapeSize[0] = size[0];
                    this.shapeSize[1] = size[1];
                    if (DragControlImpl.this.isDragGridEnabled()) {
                        this.grid = canvas.getGrid();
                        if (null == this.grid) {
                            canvas.setGrid(DragControlImpl.this.dragGrid);
                        }
                    }
                }

                public void handle(DragEvent event) {
                    DragControlImpl.this.ensureDragConstrains(shape.getShapeView(), this.shapeSize);
                }

                public void end(DragEvent event) {
                    double x = shape.getShapeView().getShapeX();
                    double y = shape.getShapeView().getShapeY();
                    DragControlImpl.this.move(element, x, y);
                    if (DragControlImpl.this.isDragGridEnabled()) {
                        canvas.setGrid(this.grid);
                        this.grid = null;
                    }
                }
            };
            hasEventHandlers.addHandler(ViewEventType.DRAG, (ViewHandler)handler);
            this.registerHandler(element.getUUID(), (ViewHandler<?>)handler);
        }
    }

    public DragControl<AbstractCanvasHandler, Element> setDragGrid(CanvasGrid grid) {
        this.dragGrid = grid;
        return this;
    }

    public CommandResult<CanvasViolation> move(Element element, double tx, double ty) {
        UpdateElementPositionCommand c = this.canvasCommandFactory.updatePosition((Node)element, tx, ty);
        CommandResult result = this.getCommandManager().allow((Object)this.canvasHandler, (Command)c);
        if (!CommandUtils.isError((CommandResult)result)) {
            result = this.getCommandManager().execute((Object)this.canvasHandler, (Command)c);
        }
        if (CommandUtils.isError((CommandResult)result)) {
            LOGGER.log(Level.SEVERE, "Update element's position command failed [result=" + result + "]");
        }
        return result;
    }

    public CommandResult<CanvasViolation> moveUp(Element element) {
        return this.translate(element, 0.0, -10.0);
    }

    public CommandResult<CanvasViolation> moveDown(Element element) {
        return this.translate(element, 0.0, 10.0);
    }

    public CommandResult<CanvasViolation> moveLeft(Element element) {
        return this.translate(element, -10.0, 0.0);
    }

    public CommandResult<CanvasViolation> moveRight(Element element) {
        return this.translate(element, 10.0, 0.0);
    }

    public CommandResult<CanvasViolation> translate(Element element, double dx, double dy) {
        Point2D p;
        try {
            p = GraphUtils.getPosition((View)((View)element.getContent()));
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.WARNING, "Update element's position command only cannot be applied to View elements.");
            return CanvasCommandResultBuilder.FAILED;
        }
        double tx = p.getX() + dx;
        double ty = p.getY() + dy;
        return this.move(element, tx, ty);
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        this.commandManagerProvider = null;
    }

    private void ensureDragConstrains(ShapeView<?> shapeView, double[] shapeSize) {
        boolean yb;
        int mw = this.canvasHandler.getCanvas().getWidth();
        int mh = this.canvasHandler.getCanvas().getHeight();
        Point2D sa = shapeView.getShapeAbsoluteLocation();
        LOGGER.log(Level.FINE, "Ensuring drag constraints for absolute coordinates at [" + sa.getX() + ", " + sa.getY() + "]");
        double ax = (double)mw - shapeSize[0];
        double ay = (double)mh - shapeSize[1];
        boolean xb = sa.getX() >= ax || sa.getX() < 0.0;
        boolean bl = yb = sa.getY() >= ay || sa.getY() < 0.0;
        if (xb || yb) {
            double tx;
            double d = sa.getX() >= ax ? ax : (tx = sa.getX() < 0.0 ? 0.0 : sa.getX());
            double ty = sa.getY() >= ay ? ay : (sa.getY() < 0.0 ? 0.0 : sa.getY());
            LOGGER.log(Level.FINE, "Setting constraint coordinates at [" + tx + ", " + ty + "]");
            shapeView.setShapeX(tx);
            shapeView.setShapeY(ty);
        }
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    private boolean isDragGridEnabled() {
        return null != this.dragGrid;
    }
}

