/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControlProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.AbstractContext;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ToolboxCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxButton;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxButtonGrid;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxButtonBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.event.ToolboxButtonEvent;
import org.kie.workbench.common.stunner.core.client.shape.NodeShape;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.uberfire.commons.validation.PortablePreconditions;

public class CanvasToolboxControl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements ToolboxControl<AbstractCanvasHandler, Element>,
IsWidget {
    private final ManagedInstance<ToolboxControlProvider> controlProviders;
    private final ToolboxFactory toolboxFactory;
    private final View view;
    private final Map<String, List<Toolbox>> toolboxMap = new HashMap<String, List<Toolbox>>();
    private String currentToolboxUUID;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    @Inject
    public CanvasToolboxControl(ManagedInstance<ToolboxControlProvider> controlProviders, ToolboxFactory toolboxFactory, View view) {
        this.controlProviders = controlProviders;
        this.toolboxFactory = toolboxFactory;
        this.view = view;
        this.currentToolboxUUID = null;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    @Override
    public void enable(AbstractCanvasHandler canvasHandler) {
        super.enable(canvasHandler);
        canvasHandler.getAbstractCanvas().addControl((IsWidget)this.asWidget());
    }

    @Override
    public void update(Element element) {
        super.update(element);
        this.deregister(element);
        this.register(element);
        this.canvasHandler.getCanvas().draw();
    }

    public void register(final Element element) {
        Shape shape;
        if (this.checkNotRegistered(element) && (shape = this.canvasHandler.getCanvas().getShape(element.getUUID())) instanceof NodeShape) {
            HasEventHandlers hasEventHandlers;
            List<ToolboxControlProvider<AbstractCanvasHandler, Element>> toolboxControlProviders = this.getToolboxProviders(element);
            if (null != toolboxControlProviders && !toolboxControlProviders.isEmpty()) {
                for (ToolboxControlProvider<AbstractCanvasHandler, Element> toolboxControlProvider : toolboxControlProviders) {
                    List commands = toolboxControlProvider.getCommands((CanvasHandler)this.canvasHandler, (Object)element);
                    if (null == commands || commands.isEmpty()) continue;
                    ToolboxBuilder toolboxBuilder = this.toolboxFactory.toolboxBuilder();
                    ToolboxButtonGrid grid = toolboxControlProvider.getGrid((CanvasHandler)this.canvasHandler, (Object)element);
                    toolboxBuilder.forLayer(this.canvasHandler.getCanvas().getLayer());
                    toolboxBuilder.forView(shape.getShapeView());
                    toolboxBuilder.direction(toolboxControlProvider.getOn(), toolboxControlProvider.getTowards());
                    toolboxBuilder.grid(grid);
                    ToolboxButtonBuilder buttonBuilder = this.toolboxFactory.toolboxButtonBuilder();
                    for (ToolboxCommand command : commands) {
                        ToolboxButton button = buttonBuilder.setIcon(command.getIcon((CanvasHandler)this.canvasHandler, (double)grid.getButtonSize(), (double)grid.getButtonSize())).setClickHandler(event -> this.fireCommandExecutionAndHideToolbox(element, command, event, Context.EventType.CLICK)).setMouseEnterHandler(event -> this.fireCommandExecution(element, command, event, Context.EventType.MOUSE_ENTER)).setMouseExitHandler(event -> this.fireCommandExecution(element, command, event, Context.EventType.MOUSE_EXIT)).setMouseDownHandler(event -> this.fireCommandExecutionAndHideToolbox(element, command, event, Context.EventType.MOUSE_DOWN)).build();
                        toolboxBuilder.add(button);
                    }
                    Toolbox toolbox = toolboxBuilder.build();
                    this.addToolbox(element.getUUID(), toolbox);
                }
            }
            if ((hasEventHandlers = (HasEventHandlers)shape.getShapeView()).supports(ViewEventType.DRAG)) {
                DragHandler handler = new DragHandler(){

                    public void handle(DragEvent event) {
                    }

                    public void start(DragEvent event) {
                        CanvasToolboxControl.this.hideToolboxes(element);
                    }

                    public void end(DragEvent event) {
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.DRAG, (ViewHandler)handler);
                this.registerHandler(element.getUUID(), (ViewHandler<?>)handler);
            }
        }
    }

    protected List<ToolboxControlProvider<AbstractCanvasHandler, Element>> getToolboxProviders(Element element) {
        if (element.getContent() instanceof org.kie.workbench.common.stunner.core.graph.content.view.View) {
            org.kie.workbench.common.stunner.core.graph.content.view.View viewContent = (org.kie.workbench.common.stunner.core.graph.content.view.View)element.getContent();
            Object definition = viewContent.getDefinition();
            LinkedList<ToolboxControlProvider<AbstractCanvasHandler, Element>> result = new LinkedList<ToolboxControlProvider<AbstractCanvasHandler, Element>>();
            this.controlProviders.forEach(c -> {
                if (c.supports(definition)) {
                    result.add((ToolboxControlProvider<AbstractCanvasHandler, Element>)c);
                }
            });
            return result;
        }
        return null;
    }

    private void addToolbox(String uuid, Toolbox toolbox) {
        if (null != uuid && null != toolbox) {
            List<Toolbox> toolboxes = this.toolboxMap.get(uuid);
            if (null == toolboxes) {
                toolboxes = new LinkedList<Toolbox>();
                this.toolboxMap.put(uuid, toolboxes);
            }
            toolboxes.add(toolbox);
        }
    }

    private void fireCommandExecution(Element element, ToolboxCommand command, ToolboxButtonEvent event, Context.EventType eventTypeType) {
        AbstractContext _context = new AbstractContext(this.canvasHandler, eventTypeType, event.getX(), event.getY(), event.getAbsoluteX(), event.getAbsoluteY(), event.getClientX(), event.getClientY()){

            public CanvasCommandManager getCommandManager() {
                return CanvasToolboxControl.this.commandManagerProvider.getCommandManager();
            }
        };
        this.setCommandView(command).execute((Context)_context, element);
    }

    private void fireCommandExecutionAndHideToolbox(Element element, ToolboxCommand command, ToolboxButtonEvent event, Context.EventType eventTypeType) {
        this.fireCommandExecution(element, command, event, eventTypeType);
        this.hideToolboxes(element);
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        this.canvasHandler.getAbstractCanvas().deleteControl((IsWidget)this.asWidget());
    }

    @Override
    public void deregisterAll() {
        super.deregisterAll();
        new HashSet<String>(this.toolboxMap.keySet()).stream().forEach(this::deregister);
        this.toolboxMap.clear();
    }

    @Override
    public void deregister(String uuid) {
        super.deregister(uuid);
        List<Toolbox> toolboxes = this.getToolboxes(uuid);
        if (null != toolboxes) {
            toolboxes.stream().forEach(Toolbox::remove);
            this.toolboxMap.remove(uuid);
        }
    }

    private ToolboxCommand setCommandView(ToolboxCommand command) {
        this.view.clear();
        if (command instanceof IsWidget) {
            this.view.addWidget((IsWidget)((IsWidget)command).asWidget());
        }
        return command;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    void onCanvasElementSelectedEvent(@Observes CanvasElementSelectedEvent event) {
        String uuid;
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event) && null != (uuid = event.getElementUUID())) {
            this.switchVisibility(uuid);
        }
    }

    void CanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (null != this.currentToolboxUUID) {
            this.setVisible(this.currentToolboxUUID, false);
            this.currentToolboxUUID = null;
        }
    }

    private boolean isVisible(String uuid) {
        return this.currentToolboxUUID != null && this.currentToolboxUUID.equals(uuid);
    }

    private void switchVisibility(String uuid) {
        if (this.isVisible(uuid)) {
            this.setVisible(this.currentToolboxUUID, false);
            this.currentToolboxUUID = null;
        } else {
            if (null != this.currentToolboxUUID) {
                this.setVisible(this.currentToolboxUUID, false);
            }
            this.setVisible(uuid, true);
            this.currentToolboxUUID = uuid;
        }
    }

    private void setVisible(String uuid, boolean visible) {
        List<Toolbox> toolboxes = this.getToolboxes(uuid);
        if (null != toolboxes) {
            for (Toolbox toolbox : toolboxes) {
                if (visible) {
                    toolbox.show();
                    continue;
                }
                toolbox.hide();
            }
        }
    }

    private void hideToolboxes(Element<?> element) {
        List<Toolbox> toolboxes = this.getToolboxes(element);
        if (null != toolboxes) {
            toolboxes.stream().forEach(Toolbox::hide);
        }
    }

    private List<Toolbox> getToolboxes(Element<?> element) {
        String uuid = null != element ? element.getUUID() : null;
        return null != uuid ? this.getToolboxes(uuid) : null;
    }

    private List<Toolbox> getToolboxes(String uuid) {
        return this.toolboxMap.get(uuid);
    }

    public static interface View
    extends IsWidget {
        public View addWidget(IsWidget var1);

        public View clear();
    }
}

