/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.AbstractToolboxControlProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ToolboxCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ToolboxCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder.NewConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder.NewNodeCommand;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxButtonGrid;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxButtonGridBuilder;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.util.CommonLookups;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
public class FlowActionsToolboxControlProvider
extends AbstractToolboxControlProvider {
    private static Logger LOGGER = Logger.getLogger(FlowActionsToolboxControlProvider.class.getName());
    private final DefinitionUtils definitionUtils;
    private final CommonLookups commonLookups;
    private final ToolboxCommandFactory defaultToolboxCommandFactory;

    protected FlowActionsToolboxControlProvider() {
        this(null, null, null, null);
    }

    @Inject
    public FlowActionsToolboxControlProvider(ToolboxFactory toolboxFactory, DefinitionUtils definitionUtils, ToolboxCommandFactory defaultToolboxCommandFactory, CommonLookups commonLookups) {
        super(toolboxFactory);
        this.definitionUtils = definitionUtils;
        this.defaultToolboxCommandFactory = defaultToolboxCommandFactory;
        this.commonLookups = commonLookups;
    }

    public boolean supports(Object definition) {
        return true;
    }

    public ToolboxButtonGrid getGrid(AbstractCanvasHandler context, Element item) {
        ToolboxButtonGridBuilder buttonGridBuilder = this.toolboxFactory.toolboxGridBuilder();
        return buttonGridBuilder.setRows(5).setColumns(2).setIconSize(12).setPadding(10).build();
    }

    public ToolboxBuilder.Direction getOn() {
        return ToolboxBuilder.Direction.NORTH_EAST;
    }

    public ToolboxBuilder.Direction getTowards() {
        return ToolboxBuilder.Direction.SOUTH_EAST;
    }

    public List<ToolboxCommand<AbstractCanvasHandler, ?>> getCommands(AbstractCanvasHandler context, Element item) {
        try {
            Set allowedMorphDefaultDefinitionIds;
            String defaultConnectorId;
            Node node = (Node)item;
            Diagram diagram = context.getDiagram();
            String defSetId = diagram.getMetadata().getDefinitionSetId();
            LinkedList commands = new LinkedList();
            Set allowedConnectorIds = this.commonLookups.getAllowedConnectors(context.getModelRulesManager(), defSetId, node, 0, 10);
            if (null != allowedConnectorIds && !allowedConnectorIds.isEmpty()) {
                for (String allowedConnectorId : allowedConnectorIds) {
                    NewConnectorCommand<?> newConnectorCommand = this.defaultToolboxCommandFactory.newConnectorCommand();
                    newConnectorCommand.setEdgeIdentifier(allowedConnectorId);
                    commands.add(newConnectorCommand);
                }
            }
            if (null != (defaultConnectorId = this.definitionUtils.getDefaultConnectorId(defSetId)) && null != (allowedMorphDefaultDefinitionIds = this.commonLookups.getAllowedMorphDefaultDefinitions(context.getModelRulesManager(), defSetId, diagram.getGraph(), (Node)item, defaultConnectorId, 0, 10)) && !allowedMorphDefaultDefinitionIds.isEmpty()) {
                for (String allowedDefId : allowedMorphDefaultDefinitionIds) {
                    NewNodeCommand<?> newNodeCommand = this.defaultToolboxCommandFactory.newNodeCommand();
                    newNodeCommand.setDefinitionIdentifier(allowedDefId);
                    commands.add(newNodeCommand);
                }
            }
            return commands;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Discarded item [" + item.getUUID() + "] for flow action toolbox controls as it's not a node.");
            return null;
        }
    }

    private void log(String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(Level.SEVERE, "** FLOW-ACTIONS-TOOLBOX ** " + message);
        }
    }
}

