/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.AbstractToolboxControlProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ToolboxCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.palette.AbstractPaletteMorphCommand;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxButtonGrid;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxButtonGridBuilder;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
public class MorphToolboxControlProvider
extends AbstractToolboxControlProvider {
    private static Logger LOGGER = Logger.getLogger(MorphToolboxControlProvider.class.getName());
    private final AbstractPaletteMorphCommand morphCommand;
    private final DefinitionUtils definitionUtils;

    protected MorphToolboxControlProvider() {
        this(null, null, null);
    }

    @Inject
    public MorphToolboxControlProvider(ToolboxFactory toolboxFactory, AbstractPaletteMorphCommand morphCommand, DefinitionUtils definitionUtils) {
        super(toolboxFactory);
        this.morphCommand = morphCommand;
        this.definitionUtils = definitionUtils;
    }

    public boolean supports(Object definition) {
        return true;
    }

    public ToolboxButtonGrid getGrid(AbstractCanvasHandler context, Element item) {
        ToolboxButtonGridBuilder buttonGridBuilder = this.toolboxFactory.toolboxGridBuilder();
        return buttonGridBuilder.setRows(1).setColumns(1).setPadding(10).build();
    }

    public ToolboxBuilder.Direction getOn() {
        return ToolboxBuilder.Direction.SOUTH_WEST;
    }

    public ToolboxBuilder.Direction getTowards() {
        return ToolboxBuilder.Direction.SOUTH_EAST;
    }

    public List<ToolboxCommand<AbstractCanvasHandler, ?>> getCommands(AbstractCanvasHandler context, Element item) {
        return !this.hasMorphTargets(item) ? null : new ArrayList<ToolboxCommand<AbstractCanvasHandler, ?>>(1){
            {
                this.add(MorphToolboxControlProvider.this.morphCommand);
            }
        };
    }

    private boolean hasMorphTargets(Element item) {
        try {
            Object def = ((Definition)item.getContent()).getDefinition();
            return this.definitionUtils.hasMorphTargets(def);
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.SEVERE, "Only contents for type Definition are expected on the toolbox morphing control provider.", e);
            return false;
        }
    }
}

