/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Point2D;
import org.kie.workbench.common.stunner.core.client.canvas.Transform;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder.AbstractBuilderCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.components.glyph.GlyphTooltip;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.uberfire.commons.validation.PortablePreconditions;

public abstract class AbstractElementBuilderCommand<I>
extends AbstractBuilderCommand<I> {
    private final ShapeManager shapeManager;
    private final DefinitionGlyphTooltip<?> glyphTooltip;
    private I iconView;
    private ShapeFactory factory;

    @Inject
    public AbstractElementBuilderCommand(ClientFactoryService clientFactoryServices, ShapeManager shapeManager, DefinitionGlyphTooltip<?> glyphTooltip, GraphBoundsIndexer graphBoundsIndexer) {
        super(clientFactoryServices, graphBoundsIndexer);
        this.shapeManager = shapeManager;
        this.glyphTooltip = glyphTooltip;
    }

    protected abstract String getGlyphDefinitionId();

    @Override
    public void destroy() {
        super.destroy();
        this.factory = null;
        this.iconView = null;
    }

    public I getIcon(AbstractCanvasHandler context, double width, double height) {
        if (null == this.iconView) {
            ShapeFactory factory = this.getFactory(context);
            Glyph glyph = factory.glyph(this.getGlyphDefinitionId(), width + 6.0, height + 6.0);
            this.iconView = glyph.getGroup();
        }
        return this.iconView;
    }

    @Override
    public void mouseEnter(Context<AbstractCanvasHandler> context, Element element) {
        super.mouseEnter(context, element);
        if (null != this.getFactory((AbstractCanvasHandler)context.getCanvasHandler())) {
            Transform transform = ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().getLayer().getTransform();
            double ax = ((AbstractCanvasHandler)context.getCanvasHandler()).getAbstractCanvas().getView().getAbsoluteX();
            double ay = ((AbstractCanvasHandler)context.getCanvasHandler()).getAbstractCanvas().getView().getAbsoluteY();
            Point2D t = transform.transform((double)context.getX(), (double)context.getY());
            this.glyphTooltip.showTooltip(this.getGlyphDefinitionId(), ax + t.getX() + 20.0, ay + t.getY(), GlyphTooltip.Direction.WEST);
        }
    }

    @Override
    public void mouseExit(Context<AbstractCanvasHandler> context, Element element) {
        super.mouseExit(context, element);
        this.glyphTooltip.hide();
    }

    protected ShapeFactory getFactory(AbstractCanvasHandler context) {
        if (null == this.factory) {
            String ssid = context.getDiagram().getMetadata().getShapeSetId();
            this.factory = this.shapeManager.getShapeSet(ssid).getShapeFactory();
        }
        return this.factory;
    }

    @Override
    protected DragProxyCallback getDragProxyCallback(final Context<AbstractCanvasHandler> context, final Element element, final Element item) {
        return new DragProxyCallback(){

            public void onStart(int x1, int y1) {
                AbstractElementBuilderCommand.this.onStart((Context<AbstractCanvasHandler>)context, element, item, x1, y1);
            }

            public void onMove(int x1, int y1) {
                AbstractElementBuilderCommand.this.onMove((Context<AbstractCanvasHandler>)context, element, item, x1, y1);
            }

            public void onComplete(int x1, int y1) {
                AbstractElementBuilderCommand.this.onComplete((Context<AbstractCanvasHandler>)context, element, item, x1, y1);
            }
        };
    }

    @Override
    protected void onItemBuilt(Context<AbstractCanvasHandler> context, String uuid) {
        super.onItemBuilt(context, uuid);
        this.glyphTooltip.hide();
    }

    protected void clearDragProxy() {
        this.getDragProxyFactory().clear();
    }

    ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    DefinitionGlyphTooltip<?> getGlyphTooltip() {
        return this.glyphTooltip;
    }

    void onKeyDownEvent(@Observes KeyDownEvent keyDownEvent) {
        PortablePreconditions.checkNotNull((String)"keyDownEvent", (Object)keyDownEvent);
        KeyboardEvent.Key key = keyDownEvent.getKey();
        if (null != key && KeyboardEvent.Key.ESC.equals((Object)key)) {
            this.clearDragProxy();
        }
    }
}

