/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.palette;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.AbstractToolboxCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxy;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.GlyphPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.model.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPaletteBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteView;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.lookup.util.CommonLookups;

public abstract class AbstractPaletteCommand<I>
extends AbstractToolboxCommand<I> {
    private static Logger LOGGER = Logger.getLogger(AbstractPaletteCommand.class.getName());
    private final I icon;
    protected final ClientFactoryService clientFactoryServices;
    protected final CommonLookups commonLookups;
    protected final ShapeManager shapeManager;
    protected final DefinitionsPaletteBuilder definitionsPaletteBuilder;
    protected final Palette<HasPaletteItems<? extends GlyphPaletteItem>> palette;
    protected final NodeDragProxy<AbstractCanvasHandler> nodeDragProxyFactory;
    protected final NodeBuilderControl<AbstractCanvasHandler> nodeBuilderControl;
    protected final GraphBoundsIndexer graphBoundsIndexer;
    protected AbstractCanvasHandler canvasHandler;
    protected CanvasHighlight canvasHighlight;
    protected Node<? extends Definition<Object>, ? extends Edge> sourceNode;
    protected boolean paletteVisible;
    protected String elementUUID;

    public AbstractPaletteCommand(ClientFactoryService clientFactoryServices, CommonLookups commonLookups, ShapeManager shapeManager, DefinitionsPaletteBuilder definitionsPaletteBuilder, Palette<HasPaletteItems<? extends GlyphPaletteItem>> palette, NodeDragProxy<AbstractCanvasHandler> nodeDragProxyFactory, NodeBuilderControl<AbstractCanvasHandler> nodeBuilderControl, GraphBoundsIndexer graphBoundsIndexer, I icon) {
        this.clientFactoryServices = clientFactoryServices;
        this.commonLookups = commonLookups;
        this.shapeManager = shapeManager;
        this.definitionsPaletteBuilder = definitionsPaletteBuilder;
        this.palette = palette;
        this.nodeDragProxyFactory = nodeDragProxyFactory;
        this.nodeBuilderControl = nodeBuilderControl;
        this.graphBoundsIndexer = graphBoundsIndexer;
        this.icon = icon;
        this.paletteVisible = false;
    }

    protected abstract Set<String> getDefinitions();

    protected abstract void onItemSelected(Context<AbstractCanvasHandler> var1, String var2, double var3, double var5);

    public I getIcon(AbstractCanvasHandler context, double width, double height) {
        return this.icon;
    }

    public String getTitle() {
        return "- Empty title -";
    }

    @Override
    public void mouseEnter(Context<AbstractCanvasHandler> context, Element element) {
        super.mouseEnter(context, element);
        this.showPalette(context, element);
    }

    @Override
    public void click(Context<AbstractCanvasHandler> context, Element element) {
        super.click(context, element);
        if (this.paletteVisible) {
            this.clear();
        } else {
            this.showPalette(context, element);
        }
    }

    protected void showPalette(final Context<AbstractCanvasHandler> context, Element element) {
        this.elementUUID = element.getUUID();
        this.paletteVisible = true;
        this.canvasHandler = (AbstractCanvasHandler)context.getCanvasHandler();
        this.sourceNode = (Node)element;
        this.graphBoundsIndexer.setRootUUID(this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID());
        Set<String> allowedDefinitions = this.getDefinitions();
        this.log(Level.FINE, "Allowed Definitions -> " + allowedDefinitions);
        if (null != allowedDefinitions && !allowedDefinitions.isEmpty()) {
            this.definitionsPaletteBuilder.build(allowedDefinitions, (PaletteDefinitionBuilder.Callback)new PaletteDefinitionBuilder.Callback<DefinitionsPalette, ClientRuntimeError>(){

                public void onSuccess(DefinitionsPalette paletteDefinition) {
                    AbstractPaletteCommand.this.initializeView(paletteDefinition, (Context<AbstractCanvasHandler>)context);
                }

                public void onError(ClientRuntimeError error) {
                    AbstractPaletteCommand.this.log(Level.SEVERE, error.toString());
                }
            });
        }
    }

    protected abstract void attachPaletteView();

    private void initializeView(DefinitionsPalette paletteDefinition, Context<AbstractCanvasHandler> context) {
        this.nodeBuilderControl.setCommandManagerProvider(() -> context.getCommandManager());
        this.beforeBindPalette(paletteDefinition, context);
        this.palette.bind((HasPaletteItems)paletteDefinition).onItemHover((id, mouseX, mouseY, itemX, itemY) -> this._onItemHover(context, id, mouseX, mouseY, itemX, itemY)).onItemOut(id -> this._onItemOut(context, id)).onItemClick((id, mouseX, mouseY, itemX, itemY) -> this._onItemClick(context, id, mouseX, mouseY, itemX, itemY)).onItemMouseDown((id, mouseX, mouseY, itemX, itemY) -> this._onItemMouseDown(context, id, mouseX, mouseY, itemX, itemY));
        this.showPaletteViewAt(context.getX(), context.getY());
    }

    protected void beforeBindPalette(DefinitionsPalette paletteDefinition, Context<AbstractCanvasHandler> context) {
    }

    protected void showPaletteViewAt(double x, double y) {
        this.getPaletteView().setX(x);
        this.getPaletteView().setY(y);
        this.attachPaletteView();
        this.getPaletteView().show();
    }

    public void clear() {
        this.nodeBuilderControl.setCommandManagerProvider(null);
        this.paletteVisible = false;
        this.elementUUID = null;
        this.getPaletteView().clear();
    }

    private boolean _onItemClick(Context<AbstractCanvasHandler> context, String id, double mouseX, double mouseY, double itemX, double itemY) {
        return true;
    }

    private boolean _onItemHover(Context<AbstractCanvasHandler> context, String id, double mouseX, double mouseY, double itemX, double itemY) {
        this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.POINTER);
        return true;
    }

    private boolean _onItemOut(Context<AbstractCanvasHandler> context, String id) {
        this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.AUTO);
        return true;
    }

    private boolean _onItemMouseDown(Context<AbstractCanvasHandler> context, String id, double mouseX, double mouseY, double itemX, double itemY) {
        this.onItemSelected(context, id, mouseX, mouseY);
        return true;
    }

    public void destroy() {
        this.palette.destroy();
        this.nodeDragProxyFactory.destroy();
        this.nodeBuilderControl.setCommandManagerProvider(null);
        this.nodeBuilderControl.disable();
        this.graphBoundsIndexer.destroy();
        this.canvasHighlight.destroy();
        this.canvasHandler = null;
        this.canvasHighlight = null;
        this.sourceNode = null;
    }

    protected abstract PaletteView getPaletteView();

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

