/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.palette;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.palette.AbstractPaletteCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxy;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.GlyphPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPaletteBuilder;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.lookup.util.CommonLookups;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public abstract class AbstractPaletteMorphCommand<I>
extends AbstractPaletteCommand<I> {
    protected final DefinitionUtils definitionUtils;
    protected final CanvasCommandFactory commandFactory;
    protected final Event<CanvasElementSelectedEvent> elementSelectedEvent;
    protected final Map<String, MorphDefinition> morphDefinitions = new HashMap<String, MorphDefinition>();

    public AbstractPaletteMorphCommand(DefinitionUtils definitionUtils, CanvasCommandFactory commandFactory, ClientFactoryService clientFactoryServices, CommonLookups commonLookups, ShapeManager shapeManager, DefinitionsPaletteBuilder definitionsPaletteBuilder, Palette<HasPaletteItems<? extends GlyphPaletteItem>> palette, NodeDragProxy<AbstractCanvasHandler> nodeDragProxyFactory, NodeBuilderControl<AbstractCanvasHandler> nodeBuilderControl, GraphBoundsIndexer graphBoundsIndexer, I icon, Event<CanvasElementSelectedEvent> elementSelectedEvent) {
        super(clientFactoryServices, commonLookups, shapeManager, definitionsPaletteBuilder, palette, nodeDragProxyFactory, nodeBuilderControl, graphBoundsIndexer, icon);
        this.definitionUtils = definitionUtils;
        this.commandFactory = commandFactory;
        this.elementSelectedEvent = elementSelectedEvent;
    }

    @Override
    protected Set<String> getDefinitions() {
        this.morphDefinitions.clear();
        Object source = ((Definition)this.sourceNode.getContent()).getDefinition();
        String id = this.getDefinitionManager().adapters().forDefinition().getId(source);
        MorphAdapter morphAdapter = this.getDefinitionManager().adapters().registry().getMorphAdapter(source.getClass());
        Iterable morphDefinitions = morphAdapter.getMorphDefinitions(source);
        if (null != morphDefinitions && morphDefinitions.iterator().hasNext()) {
            for (MorphDefinition morphDefinition : morphDefinitions) {
                Iterable morphTargets = morphAdapter.getTargets(source, morphDefinition);
                if (null == morphTargets || !morphTargets.iterator().hasNext()) continue;
                for (String morphTarget : morphTargets) {
                    if (id.equals(morphTarget)) continue;
                    this.morphDefinitions.put(morphTarget, morphDefinition);
                }
            }
        }
        if (!this.morphDefinitions.isEmpty()) {
            return new HashSet<String>(this.morphDefinitions.keySet());
        }
        return null;
    }

    @Override
    protected void onItemSelected(Context<AbstractCanvasHandler> context, String definitionId, double x, double y) {
        MorphDefinition morphDefinition = this.morphDefinitions.get(definitionId);
        Node node = this.sourceNode;
        String ssid = this.canvasHandler.getDiagram().getMetadata().getShapeSetId();
        context.getCommandManager().execute((Object)this.canvasHandler, (Command)this.commandFactory.morphNode(node, morphDefinition, definitionId, ssid));
        this.morphDefinitions.clear();
        this.clear();
        this.fireElementSelectedEvent(this.elementSelectedEvent, this.canvasHandler, node.getUUID());
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }
}

