/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class CanvasLayoutUtils {
    private static Logger LOGGER = Logger.getLogger(CanvasLayoutUtils.class.getName());
    private static final int PADDING = 50;
    private static final float MARGIN = 0.2f;

    public static boolean isCanvasRoot(Diagram diagram, Element parent) {
        return null != parent && CanvasLayoutUtils.isCanvasRoot(diagram, parent.getUUID());
    }

    public static boolean isCanvasRoot(Diagram diagram, String pUUID) {
        String canvasRoot = diagram.getMetadata().getCanvasRootUUID();
        return null != canvasRoot && null != pUUID && canvasRoot.equals(pUUID);
    }

    public double[] getNext(CanvasHandler canvasHandler, double width, double height) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        Bounds bounds = this.getGraphBounds(canvasHandler);
        Bounds.Bound ul = bounds.getUpperLeft();
        String ruuid = canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
        if (null != ruuid) {
            Node root = canvasHandler.getDiagram().getGraph().getNode(ruuid);
            return this.getNext(canvasHandler, root, width, height, ul.getX(), ul.getY());
        }
        Iterable nodes = canvasHandler.getDiagram().getGraph().nodes();
        if (null != nodes) {
            Bounds.Bound lr = bounds.getLowerRight();
            LinkedList nodeList = new LinkedList();
            nodes.forEach(nodeList::add);
            return this.getNext(canvasHandler, nodeList, width, height, ul.getX(), ul.getY(), lr.getX() - 50.0, lr.getY() - 50.0);
        }
        return new double[]{ul.getX(), ul.getY()};
    }

    public double[] getNext(CanvasHandler canvasHandler, double w, double h, double minX, double minY) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        String ruuid = canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
        if (null != ruuid) {
            Node root = canvasHandler.getDiagram().getGraph().getNode(ruuid);
            return this.getNext(canvasHandler, root, w, h, minX, minY);
        }
        Bounds bounds = this.getGraphBounds(canvasHandler);
        Bounds.Bound lr = bounds.getLowerRight();
        Iterable nodes = canvasHandler.getDiagram().getGraph().nodes();
        if (null != nodes) {
            LinkedList nodeList = new LinkedList();
            nodes.forEach(nodeList::add);
            return this.getNext(canvasHandler, nodeList, w, h, minX, minY, lr.getX() - 50.0, lr.getY() - 50.0);
        }
        return new double[]{minX, minY};
    }

    public double[] getNext(CanvasHandler canvasHandler, Node<View<?>, Edge> root) {
        double[] rootBounds = this.getBoundCoordinates((View)root.getContent());
        double[] size = GraphUtils.getNodeSize((View)((View)root.getContent()));
        return this.getNext(canvasHandler, root, size[0], size[1], rootBounds[0], rootBounds[1]);
    }

    public double[] getNext(CanvasHandler canvasHandler, Node<View<?>, Edge> root, double w, double h, double minX, double minY) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        PortablePreconditions.checkNotNull((String)"root", root);
        List outEdges = root.getOutEdges();
        if (null != outEdges) {
            LinkedList nodes = new LinkedList();
            outEdges.stream().forEach(edge -> {
                if (edge instanceof Child && edge.getTargetNode().getContent() instanceof View) {
                    nodes.add(edge.getTargetNode());
                }
            });
            if (!nodes.isEmpty()) {
                double[] rootBounds = this.getBoundCoordinates((View)root.getContent());
                double[] n = this.getNext(canvasHandler, nodes, w, h, minX, minY, rootBounds[0] - 50.0, rootBounds[1] - 50.0);
                return new double[]{n[0] + 50.0, n[1]};
            }
        }
        Bounds bounds = this.getGraphBounds(canvasHandler);
        Bounds.Bound lr = bounds.getLowerRight();
        return this.check(minX, minY, w, h, minX, minY, lr.getX() - 50.0, lr.getY() - 50.0);
    }

    private double[] getNext(CanvasHandler canvasHandler, List<Node<View<?>, Edge>> nodes, double width, double height, double minX, double minY, double maxX, double maxY) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        PortablePreconditions.checkNotNull((String)"nodes", nodes);
        double[] result = new double[]{minX, minY};
        nodes.stream().forEach(node -> {
            double[] coordinates = this.getAbsolute((Node<View<?>, Edge>)node);
            result[0] = coordinates[0] >= result[0] ? coordinates[0] : result[0];
            result[1] = coordinates[1] >= result[1] ? coordinates[1] : result[1];
            double[] r = this.check(coordinates[0], coordinates[1], width, height, minX, minY, maxX, maxY);
            if (coordinates[0] + width >= maxX) {
                result[0] = r[0];
                result[1] = r[1];
            }
            if (result[1] + height > maxX) {
                throw new LayoutBoundExceededException(result[0], result[1], maxX, maxY);
            }
        });
        return result;
    }

    private double[] check(double x, double y, double w, double h, double lx, double ly, double ux, double uy) {
        double[] result = new double[]{x, y};
        if (x + w >= ux) {
            result[0] = lx;
            result[1] = result[1] + (y + 50.0);
        }
        if (y + h > uy) {
            throw new LayoutBoundExceededException(result[0], result[1], ux, uy);
        }
        return new double[]{result[0] + 50.0, result[1]};
    }

    private double[] getAbsolute(Node<View<?>, Edge> root) {
        double[] pos = this.getBoundCoordinates((View)root.getContent());
        return this.getAbsolute(root, pos[0], pos[1]);
    }

    private double[] getAbsolute(Node<View<?>, Edge> root, double x, double y) {
        Element parent = GraphUtils.getParent(root);
        if (null != parent && parent instanceof Node && parent.getContent() instanceof View) {
            double[] pos = this.getBoundCoordinates((View)parent.getContent());
            return this.getAbsolute((Node)parent, x + pos[0], y + pos[1]);
        }
        return new double[]{x, y};
    }

    private double[] getBoundCoordinates(View view) {
        Bounds bounds = view.getBounds();
        Bounds.Bound ulBound = bounds.getUpperLeft();
        Bounds.Bound lrBound = bounds.getLowerRight();
        double lrX = lrBound.getX();
        double lrY = ulBound.getY();
        return new double[]{lrX, lrY};
    }

    private Bounds getGraphBounds(CanvasHandler canvasHandler) {
        Graph graph = canvasHandler.getDiagram().getGraph();
        return ((DefinitionSet)graph.getContent()).getBounds();
    }

    public class LayoutBoundExceededException
    extends RuntimeException {
        private final double x;
        private final double y;
        private final double maxX;
        private final double maxY;

        public LayoutBoundExceededException(double x, double y, double maxX, double maxY) {
            this.x = x;
            this.y = y;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }
}

