/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandAllowedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandListener;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.DelegateCommandManager;
import org.kie.workbench.common.stunner.core.command.HasCommandListener;
import org.kie.workbench.common.stunner.core.command.impl.CommandManagerImpl;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

@Dependent
public class CanvasCommandManagerImpl<H extends AbstractCanvasHandler>
extends DelegateCommandManager<H, CanvasViolation>
implements CanvasCommandManager<H>,
HasCommandListener<CommandListener<H, CanvasViolation>> {
    private final Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent;
    private final Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent;
    private final Event<CanvasUndoCommandExecutedEvent> canvasUndoCommandExecutedEvent;
    private final CommandManager<H, CanvasViolation> commandManager;
    private CommandListener<H, CanvasViolation> listener;

    protected CanvasCommandManagerImpl() {
        this(null, null, null);
    }

    @Inject
    public CanvasCommandManagerImpl(Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent, Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent, Event<CanvasUndoCommandExecutedEvent> canvasUndoCommandExecutedEvent) {
        this.isCanvasCommandAllowedEvent = isCanvasCommandAllowedEvent;
        this.canvasCommandExecutedEvent = canvasCommandExecutedEvent;
        this.canvasUndoCommandExecutedEvent = canvasUndoCommandExecutedEvent;
        this.commandManager = new CommandManagerImpl();
        this.listener = null;
    }

    protected CommandManager<H, CanvasViolation> getDelegate() {
        return this.commandManager;
    }

    protected void postAllow(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postAllow(context, command, result);
        if (null != this.listener) {
            this.listener.onAllow(context, command, result);
        }
        if (null != result && null != this.isCanvasCommandAllowedEvent) {
            this.isCanvasCommandAllowedEvent.fire((Object)new CanvasCommandAllowedEvent(context, command, result));
        }
    }

    protected void postExecute(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postExecute(context, command, result);
        if (null != result && !CommandUtils.isError(result)) {
            this.draw(context);
        }
        if (null != this.listener) {
            this.listener.onExecute(context, command, result);
        }
        if (null != result && null != this.canvasCommandExecutedEvent) {
            this.canvasCommandExecutedEvent.fire((Object)new CanvasCommandExecutedEvent(context, command, result));
        }
    }

    protected void postUndo(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        super.postUndo(context, command, result);
        if (null != result && !CommandUtils.isError(result)) {
            this.draw(context);
        }
        if (null != this.listener) {
            this.listener.onUndo(context, command, result);
        }
        if (null != this.canvasUndoCommandExecutedEvent) {
            this.canvasUndoCommandExecutedEvent.fire((Object)new CanvasUndoCommandExecutedEvent(context, command, result));
        }
    }

    public void setCommandListener(CommandListener<H, CanvasViolation> listener) {
        this.listener = listener;
    }

    private void draw(H context) {
        context.getCanvas().draw();
    }
}

