/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette;

import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;

public abstract class AbstractPalette<D extends HasPaletteItems>
implements Palette<D> {
    protected final ShapeManager shapeManager;
    protected Palette.CloseCallback closeCallback;
    protected Palette.ItemHoverCallback itemHoverCallback;
    protected Palette.ItemOutCallback itemOutCallback;
    protected Palette.ItemMouseDownCallback itemMouseDownCallback;
    protected Palette.ItemClickCallback itemClickCallback;
    protected D paletteDefinition;

    protected AbstractPalette() {
        this(null);
    }

    protected AbstractPalette(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    protected abstract AbstractPalette<D> bind();

    protected abstract void doDestroy();

    protected abstract String getPaletteItemId(int var1);

    public AbstractPalette<D> bind(D paletteDefinition) {
        this.paletteDefinition = paletteDefinition;
        this.beforeBind();
        this.bind();
        this.afterBind();
        return this;
    }

    protected void beforeBind() {
    }

    protected void afterBind() {
    }

    public AbstractPalette<D> onClose(Palette.CloseCallback callback) {
        this.closeCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemHover(Palette.ItemHoverCallback callback) {
        this.itemHoverCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemOut(Palette.ItemOutCallback callback) {
        this.itemOutCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemMouseDown(Palette.ItemMouseDownCallback callback) {
        this.itemMouseDownCallback = callback;
        return this;
    }

    public AbstractPalette<D> onItemClick(Palette.ItemClickCallback callback) {
        this.itemClickCallback = callback;
        return this;
    }

    public boolean onClose() {
        this.doClose();
        if (null != this.closeCallback) {
            return this.closeCallback.onClose();
        }
        return true;
    }

    protected void doClose() {
    }

    public boolean onItemHover(int index, double mouseX, double mouseY, double itemX, double itemY) {
        String id = this.getPaletteItemId(index);
        this.doItemHover(id, mouseX, mouseY, itemX, itemY);
        if (null != this.itemHoverCallback) {
            return this.itemHoverCallback.onItemHover(this.getPaletteItemId(index), mouseX, mouseY, itemX, itemY);
        }
        return true;
    }

    protected void doItemHover(String id, double mouseX, double mouseY, double itemX, double itemY) {
    }

    public boolean onItemOut(int index) {
        if (null != this.itemOutCallback) {
            return this.itemOutCallback.onItemOut(this.getPaletteItemId(index));
        }
        return true;
    }

    public boolean onItemMouseDown(int index, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemMouseDownCallback) {
            String id = this.getPaletteItemId(index);
            return this.onItemMouseDown(id, mouseX, mouseY, itemX, itemY);
        }
        return true;
    }

    public boolean onItemMouseDown(String id, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemMouseDownCallback) {
            return this.itemMouseDownCallback.onItemMouseDown(id, mouseX, mouseY, itemX, itemY);
        }
        return true;
    }

    public boolean onItemClick(int index, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemClickCallback) {
            String id = this.getPaletteItemId(index);
            return this.itemClickCallback.onItemClick(id, mouseX, mouseY, itemX, itemY);
        }
        return true;
    }

    public boolean onItemClick(String id, double mouseX, double mouseY, double itemX, double itemY) {
        if (null != this.itemClickCallback) {
            return this.itemClickCallback.onItemClick(id, mouseX, mouseY, itemX, itemY);
        }
        return true;
    }

    public D getDefinition() {
        return this.paletteDefinition;
    }

    public void destroy() {
        this.doDestroy();
        this.closeCallback = null;
        this.itemHoverCallback = null;
        this.itemOutCallback = null;
        this.itemMouseDownCallback = null;
        this.itemClickCallback = null;
        this.paletteDefinition = null;
    }
}

